package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KResourceBuilder extends KResourceFluent<KResourceBuilder> implements VisitableBuilder<KResource,KResourceBuilder>{
  public KResourceBuilder() {
    this(new KResource());
  }
  
  public KResourceBuilder(KResourceFluent<?> fluent) {
    this(fluent, new KResource());
  }
  
  public KResourceBuilder(KResourceFluent<?> fluent,KResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KResourceBuilder(KResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KResourceFluent<?> fluent;
  
  public KResource build() {
    KResource buildable = new KResource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildStatus());
    return buildable;
  }
  

}