package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodSpecableBuilder extends PodSpecableFluent<PodSpecableBuilder> implements VisitableBuilder<PodSpecable,PodSpecableBuilder>{
  public PodSpecableBuilder() {
    this(new PodSpecable());
  }
  
  public PodSpecableBuilder(PodSpecableFluent<?> fluent) {
    this(fluent, new PodSpecable());
  }
  
  public PodSpecableBuilder(PodSpecableFluent<?> fluent,PodSpecable instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodSpecableBuilder(PodSpecable instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodSpecableFluent<?> fluent;
  
  public PodSpecable build() {
    PodSpecable buildable = new PodSpecable(fluent.buildMetadata(),fluent.getSpec());
    return buildable;
  }
  

}