package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SourceListBuilder extends SourceListFluent<SourceListBuilder> implements VisitableBuilder<SourceList,SourceListBuilder>{
  public SourceListBuilder() {
    this(new SourceList());
  }
  
  public SourceListBuilder(SourceListFluent<?> fluent) {
    this(fluent, new SourceList());
  }
  
  public SourceListBuilder(SourceListFluent<?> fluent,SourceList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SourceListBuilder(SourceList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SourceListFluent<?> fluent;
  
  public SourceList build() {
    SourceList buildable = new SourceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}