package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WithPodBuilder extends WithPodFluent<WithPodBuilder> implements VisitableBuilder<WithPod,WithPodBuilder>{
  public WithPodBuilder() {
    this(new WithPod());
  }
  
  public WithPodBuilder(WithPodFluent<?> fluent) {
    this(fluent, new WithPod());
  }
  
  public WithPodBuilder(WithPodFluent<?> fluent,WithPod instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WithPodBuilder(WithPod instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WithPodFluent<?> fluent;
  
  public WithPod build() {
    WithPod buildable = new WithPod(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    return buildable;
  }
  

}