package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AddressableBuilder extends AddressableFluent<AddressableBuilder> implements VisitableBuilder<Addressable,AddressableBuilder>{
  public AddressableBuilder() {
    this(new Addressable());
  }
  
  public AddressableBuilder(AddressableFluent<?> fluent) {
    this(fluent, new Addressable());
  }
  
  public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AddressableBuilder(Addressable instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AddressableFluent<?> fluent;
  
  public Addressable build() {
    Addressable buildable = new Addressable(fluent.getCACerts(),fluent.getHostname(),fluent.getName(),fluent.getUrl());
    return buildable;
  }
  

}