package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TargetBuilder extends TargetFluent<TargetBuilder> implements VisitableBuilder<Target,TargetBuilder>{
  public TargetBuilder() {
    this(new Target());
  }
  
  public TargetBuilder(TargetFluent<?> fluent) {
    this(fluent, new Target());
  }
  
  public TargetBuilder(TargetFluent<?> fluent,Target instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TargetBuilder(Target instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TargetFluent<?> fluent;
  
  public Target build() {
    Target buildable = new Target(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildStatus());
    return buildable;
  }
  

}