package io.fabric8.knative.internal.pkg.tracker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReferenceBuilder extends ReferenceFluent<ReferenceBuilder> implements VisitableBuilder<Reference,ReferenceBuilder>{
  public ReferenceBuilder() {
    this(new Reference());
  }
  
  public ReferenceBuilder(ReferenceFluent<?> fluent) {
    this(fluent, new Reference());
  }
  
  public ReferenceBuilder(ReferenceFluent<?> fluent,Reference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReferenceBuilder(Reference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReferenceFluent<?> fluent;
  
  public Reference build() {
    Reference buildable = new Reference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.buildSelector());
    return buildable;
  }
  

}