package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ChannelBuilder extends ChannelFluent<ChannelBuilder> implements VisitableBuilder<Channel,ChannelBuilder>{
  public ChannelBuilder() {
    this(new Channel());
  }
  
  public ChannelBuilder(ChannelFluent<?> fluent) {
    this(fluent, new Channel());
  }
  
  public ChannelBuilder(ChannelFluent<?> fluent,Channel instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ChannelBuilder(Channel instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ChannelFluent<?> fluent;
  
  public Channel build() {
    Channel buildable = new Channel(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}