package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluent;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ChannelSpecFluent<A extends ChannelSpecFluent<A>> extends BaseFluent<A>{
  public ChannelSpecFluent() {
  }
  
  public ChannelSpecFluent(ChannelSpec instance) {
    this.copyInstance(instance);
  }
  private ChannelTemplateSpecBuilder channelTemplate;
  private DeliverySpecBuilder delivery;
  private ArrayList<SubscriberSpecBuilder> subscribers = new ArrayList<SubscriberSpecBuilder>();
  
  protected void copyInstance(ChannelSpec instance) {
    instance = (instance != null ? instance : new ChannelSpec());
  
    if (instance != null) {
        this.withChannelTemplate(instance.getChannelTemplate());
        this.withDelivery(instance.getDelivery());
        this.withSubscribers(instance.getSubscribers());
        this.withChannelTemplate(instance.getChannelTemplate());
        this.withDelivery(instance.getDelivery());
        this.withSubscribers(instance.getSubscribers());
      }
  }
  
  public ChannelTemplateSpec buildChannelTemplate() {
    return this.channelTemplate!=null ?this.channelTemplate.build():null;
  }
  
  public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
    _visitables.get("channelTemplate").remove(this.channelTemplate);
    if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} else { this.channelTemplate = null; _visitables.get("channelTemplate").remove(this.channelTemplate); } return (A) this;
  }
  
  public boolean hasChannelTemplate() {
    return this.channelTemplate != null;
  }
  
  public ChannelTemplateNested<A> withNewChannelTemplate() {
    return new ChannelTemplateNested(null);
  }
  
  public ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
    return new ChannelTemplateNested(item);
  }
  
  public ChannelTemplateNested<A> editChannelTemplate() {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(null));
  }
  
  public ChannelTemplateNested<A> editOrNewChannelTemplate() {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(new ChannelTemplateSpecBuilder().build()));
  }
  
  public ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(item));
  }
  
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  
  public A addToSubscribers(int index,SubscriberSpec item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
    if (index < 0 || index >= subscribers.size()) { _visitables.get("subscribers").add(builder); subscribers.add(builder); } else { _visitables.get("subscribers").add(index, builder); subscribers.add(index, builder);}
    return (A)this;
  }
  
  public A setToSubscribers(int index,SubscriberSpec item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
    if (index < 0 || index >= subscribers.size()) { _visitables.get("subscribers").add(builder); subscribers.add(builder); } else { _visitables.get("subscribers").set(index, builder); subscribers.set(index, builder);}
    return (A)this;
  }
  
  public A addToSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  
  public A addAllToSubscribers(Collection<SubscriberSpec> items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  
  public A removeFromSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... items) {
    if (this.subscribers == null) return (A)this;
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder); this.subscribers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
    if (this.subscribers == null) return (A)this;
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder); this.subscribers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
    if (subscribers == null) return (A) this;
    final Iterator<SubscriberSpecBuilder> each = subscribers.iterator();
    final List visitables = _visitables.get("subscribers");
    while (each.hasNext()) {
      SubscriberSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SubscriberSpec> buildSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  
  public SubscriberSpec buildSubscriber(int index) {
    return this.subscribers.get(index).build();
  }
  
  public SubscriberSpec buildFirstSubscriber() {
    return this.subscribers.get(0).build();
  }
  
  public SubscriberSpec buildLastSubscriber() {
    return this.subscribers.get(subscribers.size() - 1).build();
  }
  
  public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSubscribers(List<SubscriberSpec> subscribers) {
    if (this.subscribers != null) { _visitables.get("subscribers").clear();}
    if (subscribers != null) {this.subscribers = new ArrayList(); for (SubscriberSpec item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
  }
  
  public A withSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... subscribers) {
    if (this.subscribers != null) {this.subscribers.clear(); _visitables.remove("subscribers"); }
    if (subscribers != null) {for (SubscriberSpec item :subscribers){ this.addToSubscribers(item);}} return (A) this;
  }
  
  public boolean hasSubscribers() {
    return subscribers != null && !subscribers.isEmpty();
  }
  
  public SubscribersNested<A> addNewSubscriber() {
    return new SubscribersNested(-1, null);
  }
  
  public SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
    return new SubscribersNested(-1, item);
  }
  
  public SubscribersNested<A> setNewSubscriberLike(int index,SubscriberSpec item) {
    return new SubscribersNested(index, item);
  }
  
  public SubscribersNested<A> editSubscriber(int index) {
    if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  
  public SubscribersNested<A> editFirstSubscriber() {
    if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
    return setNewSubscriberLike(0, buildSubscriber(0));
  }
  
  public SubscribersNested<A> editLastSubscriber() {
    int index = subscribers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  
  public SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscribers.size();i++) { 
    if (predicate.test(subscribers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ChannelSpecFluent that = (ChannelSpecFluent) o;
    if (!java.util.Objects.equals(channelTemplate, that.channelTemplate)) return false;
  
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;
  
    if (!java.util.Objects.equals(subscribers, that.subscribers)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(channelTemplate,  delivery,  subscribers,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channelTemplate != null) { sb.append("channelTemplate:"); sb.append(channelTemplate + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (subscribers != null && !subscribers.isEmpty()) { sb.append("subscribers:"); sb.append(subscribers); }
    sb.append("}");
    return sb.toString();
  }
  public class ChannelTemplateNested<N> extends ChannelTemplateSpecFluent<ChannelTemplateNested<N>> implements Nested<N>{
    ChannelTemplateNested(ChannelTemplateSpec item) {
      this.builder = new ChannelTemplateSpecBuilder(this, item);
    }
    ChannelTemplateSpecBuilder builder;
    
    public N and() {
      return (N) ChannelSpecFluent.this.withChannelTemplate(builder.build());
    }
    
    public N endChannelTemplate() {
      return and();
    }
    
  
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    
    public N and() {
      return (N) ChannelSpecFluent.this.withDelivery(builder.build());
    }
    
    public N endDelivery() {
      return and();
    }
    
  
  }
  public class SubscribersNested<N> extends SubscriberSpecFluent<SubscribersNested<N>> implements Nested<N>{
    SubscribersNested(int index,SubscriberSpec item) {
      this.index = index;
      this.builder = new SubscriberSpecBuilder(this, item);
    }
    SubscriberSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) ChannelSpecFluent.this.setToSubscribers(index,builder.build());
    }
    
    public N endSubscriber() {
      return and();
    }
    
  
  }

}