package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InMemoryChannelSpecBuilder extends InMemoryChannelSpecFluent<InMemoryChannelSpecBuilder> implements VisitableBuilder<InMemoryChannelSpec,InMemoryChannelSpecBuilder>{
  public InMemoryChannelSpecBuilder() {
    this(new InMemoryChannelSpec());
  }
  
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent) {
    this(fluent, new InMemoryChannelSpec());
  }
  
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InMemoryChannelSpecFluent<?> fluent;
  
  public InMemoryChannelSpec build() {
    InMemoryChannelSpec buildable = new InMemoryChannelSpec(fluent.buildDelivery(),fluent.buildSubscribers());
    return buildable;
  }
  

}