package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InMemoryChannelStatusBuilder extends InMemoryChannelStatusFluent<InMemoryChannelStatusBuilder> implements VisitableBuilder<InMemoryChannelStatus,InMemoryChannelStatusBuilder>{
  public InMemoryChannelStatusBuilder() {
    this(new InMemoryChannelStatus());
  }
  
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent) {
    this(fluent, new InMemoryChannelStatus());
  }
  
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InMemoryChannelStatusFluent<?> fluent;
  
  public InMemoryChannelStatus build() {
    InMemoryChannelStatus buildable = new InMemoryChannelStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.buildSubscribers());
    return buildable;
  }
  

}