package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigurationListBuilder extends ConfigurationListFluent<ConfigurationListBuilder> implements VisitableBuilder<ConfigurationList,ConfigurationListBuilder>{
  public ConfigurationListBuilder() {
    this(new ConfigurationList());
  }
  
  public ConfigurationListBuilder(ConfigurationListFluent<?> fluent) {
    this(fluent, new ConfigurationList());
  }
  
  public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,ConfigurationList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigurationListBuilder(ConfigurationList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigurationListFluent<?> fluent;
  
  public ConfigurationList build() {
    ConfigurationList buildable = new ConfigurationList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}