package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigurationStatusBuilder extends ConfigurationStatusFluent<ConfigurationStatusBuilder> implements VisitableBuilder<ConfigurationStatus,ConfigurationStatusBuilder>{
  public ConfigurationStatusBuilder() {
    this(new ConfigurationStatus());
  }
  
  public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent) {
    this(fluent, new ConfigurationStatus());
  }
  
  public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,ConfigurationStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigurationStatusBuilder(ConfigurationStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigurationStatusFluent<?> fluent;
  
  public ConfigurationStatus build() {
    ConfigurationStatus buildable = new ConfigurationStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getLatestCreatedRevisionName(),fluent.getLatestReadyRevisionName(),fluent.getObservedGeneration());
    return buildable;
  }
  

}