package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RevisionStatusFluent<A extends RevisionStatusFluent<A>> extends BaseFluent<A>{
  public RevisionStatusFluent() {
  }
  
  public RevisionStatusFluent(RevisionStatus instance) {
    this.copyInstance(instance);
  }
  private Integer actualReplicas;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList<ContainerStatusBuilder>();
  private Integer desiredReplicas;
  private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
  private String logUrl;
  private Long observedGeneration;
  
  protected void copyInstance(RevisionStatus instance) {
    instance = (instance != null ? instance : new RevisionStatus());
  
    if (instance != null) {
        this.withActualReplicas(instance.getActualReplicas());
        this.withAnnotations(instance.getAnnotations());
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withLogUrl(instance.getLogUrl());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withActualReplicas(instance.getActualReplicas());
        this.withAnnotations(instance.getAnnotations());
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withLogUrl(instance.getLogUrl());
        this.withObservedGeneration(instance.getObservedGeneration());
      }
  }
  
  public Integer getActualReplicas() {
    return this.actualReplicas;
  }
  
  public A withActualReplicas(Integer actualReplicas) {
    this.actualReplicas=actualReplicas; return (A) this;
  }
  
  public boolean hasActualReplicas() {
    return this.actualReplicas != null;
  }
  
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToContainerStatuses(int index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= containerStatuses.size()) { _visitables.get("containerStatuses").add(builder); containerStatuses.add(builder); } else { _visitables.get("containerStatuses").add(index, builder); containerStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToContainerStatuses(int index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= containerStatuses.size()) { _visitables.get("containerStatuses").add(builder); containerStatuses.add(builder); } else { _visitables.get("containerStatuses").set(index, builder); containerStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.containerStatuses == null) return (A)this;
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder); this.containerStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
    if (this.containerStatuses == null) return (A)this;
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder); this.containerStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (containerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = containerStatuses.iterator();
    final List visitables = _visitables.get("containerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ContainerStatus> buildContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  
  public ContainerStatus buildContainerStatus(int index) {
    return this.containerStatuses.get(index).build();
  }
  
  public ContainerStatus buildFirstContainerStatus() {
    return this.containerStatuses.get(0).build();
  }
  
  public ContainerStatus buildLastContainerStatus() {
    return this.containerStatuses.get(containerStatuses.size() - 1).build();
  }
  
  public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
    if (this.containerStatuses != null) { _visitables.get("containerStatuses").clear();}
    if (containerStatuses != null) {this.containerStatuses = new ArrayList(); for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
  }
  
  public A withContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... containerStatuses) {
    if (this.containerStatuses != null) {this.containerStatuses.clear(); _visitables.remove("containerStatuses"); }
    if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
  }
  
  public boolean hasContainerStatuses() {
    return containerStatuses != null && !containerStatuses.isEmpty();
  }
  
  public A addNewContainerStatus(String imageDigest,String name) {
    return (A)addToContainerStatuses(new ContainerStatus(imageDigest, name));
  }
  
  public ContainerStatusesNested<A> addNewContainerStatus() {
    return new ContainerStatusesNested(-1, null);
  }
  
  public ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
    return new ContainerStatusesNested(-1, item);
  }
  
  public ContainerStatusesNested<A> setNewContainerStatusLike(int index,ContainerStatus item) {
    return new ContainerStatusesNested(index, item);
  }
  
  public ContainerStatusesNested<A> editContainerStatus(int index) {
    if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  
  public ContainerStatusesNested<A> editFirstContainerStatus() {
    if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
    return setNewContainerStatusLike(0, buildContainerStatus(0));
  }
  
  public ContainerStatusesNested<A> editLastContainerStatus() {
    int index = containerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  
  public ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerStatuses.size();i++) { 
    if (predicate.test(containerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  
  public Integer getDesiredReplicas() {
    return this.desiredReplicas;
  }
  
  public A withDesiredReplicas(Integer desiredReplicas) {
    this.desiredReplicas=desiredReplicas; return (A) this;
  }
  
  public boolean hasDesiredReplicas() {
    return this.desiredReplicas != null;
  }
  
  public A addToInitContainerStatuses(int index,ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= initContainerStatuses.size()) { _visitables.get("initContainerStatuses").add(builder); initContainerStatuses.add(builder); } else { _visitables.get("initContainerStatuses").add(index, builder); initContainerStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToInitContainerStatuses(int index,ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= initContainerStatuses.size()) { _visitables.get("initContainerStatuses").add(builder); initContainerStatuses.add(builder); } else { _visitables.get("initContainerStatuses").set(index, builder); initContainerStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToInitContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromInitContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.initContainerStatuses == null) return (A)this;
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder); this.initContainerStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
    if (this.initContainerStatuses == null) return (A)this;
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder); this.initContainerStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (initContainerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = initContainerStatuses.iterator();
    final List visitables = _visitables.get("initContainerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ContainerStatus> buildInitContainerStatuses() {
    return initContainerStatuses != null ? build(initContainerStatuses) : null;
  }
  
  public ContainerStatus buildInitContainerStatus(int index) {
    return this.initContainerStatuses.get(index).build();
  }
  
  public ContainerStatus buildFirstInitContainerStatus() {
    return this.initContainerStatuses.get(0).build();
  }
  
  public ContainerStatus buildLastInitContainerStatus() {
    return this.initContainerStatuses.get(initContainerStatuses.size() - 1).build();
  }
  
  public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
    if (this.initContainerStatuses != null) { _visitables.get("initContainerStatuses").clear();}
    if (initContainerStatuses != null) {this.initContainerStatuses = new ArrayList(); for (ContainerStatus item : initContainerStatuses){this.addToInitContainerStatuses(item);}} else { this.initContainerStatuses = null;} return (A) this;
  }
  
  public A withInitContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... initContainerStatuses) {
    if (this.initContainerStatuses != null) {this.initContainerStatuses.clear(); _visitables.remove("initContainerStatuses"); }
    if (initContainerStatuses != null) {for (ContainerStatus item :initContainerStatuses){ this.addToInitContainerStatuses(item);}} return (A) this;
  }
  
  public boolean hasInitContainerStatuses() {
    return initContainerStatuses != null && !initContainerStatuses.isEmpty();
  }
  
  public A addNewInitContainerStatus(String imageDigest,String name) {
    return (A)addToInitContainerStatuses(new ContainerStatus(imageDigest, name));
  }
  
  public InitContainerStatusesNested<A> addNewInitContainerStatus() {
    return new InitContainerStatusesNested(-1, null);
  }
  
  public InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
    return new InitContainerStatusesNested(-1, item);
  }
  
  public InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index,ContainerStatus item) {
    return new InitContainerStatusesNested(index, item);
  }
  
  public InitContainerStatusesNested<A> editInitContainerStatus(int index) {
    if (initContainerStatuses.size() <= index) throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  
  public InitContainerStatusesNested<A> editFirstInitContainerStatus() {
    if (initContainerStatuses.size() == 0) throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(0, buildInitContainerStatus(0));
  }
  
  public InitContainerStatusesNested<A> editLastInitContainerStatus() {
    int index = initContainerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  
  public InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainerStatuses.size();i++) { 
    if (predicate.test(initContainerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  
  public String getLogUrl() {
    return this.logUrl;
  }
  
  public A withLogUrl(String logUrl) {
    this.logUrl=logUrl; return (A) this;
  }
  
  public boolean hasLogUrl() {
    return this.logUrl != null;
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RevisionStatusFluent that = (RevisionStatusFluent) o;
    if (!java.util.Objects.equals(actualReplicas, that.actualReplicas)) return false;
  
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;
  
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(containerStatuses, that.containerStatuses)) return false;
  
    if (!java.util.Objects.equals(desiredReplicas, that.desiredReplicas)) return false;
  
    if (!java.util.Objects.equals(initContainerStatuses, that.initContainerStatuses)) return false;
  
    if (!java.util.Objects.equals(logUrl, that.logUrl)) return false;
  
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(actualReplicas,  annotations,  conditions,  containerStatuses,  desiredReplicas,  initContainerStatuses,  logUrl,  observedGeneration,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actualReplicas != null) { sb.append("actualReplicas:"); sb.append(actualReplicas + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (containerStatuses != null && !containerStatuses.isEmpty()) { sb.append("containerStatuses:"); sb.append(containerStatuses + ","); }
    if (desiredReplicas != null) { sb.append("desiredReplicas:"); sb.append(desiredReplicas + ","); }
    if (initContainerStatuses != null && !initContainerStatuses.isEmpty()) { sb.append("initContainerStatuses:"); sb.append(initContainerStatuses + ","); }
    if (logUrl != null) { sb.append("logUrl:"); sb.append(logUrl + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) RevisionStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ContainerStatusesNested<N> extends ContainerStatusFluent<ContainerStatusesNested<N>> implements Nested<N>{
    ContainerStatusesNested(int index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) RevisionStatusFluent.this.setToContainerStatuses(index,builder.build());
    }
    
    public N endContainerStatus() {
      return and();
    }
    
  
  }
  public class InitContainerStatusesNested<N> extends ContainerStatusFluent<InitContainerStatusesNested<N>> implements Nested<N>{
    InitContainerStatusesNested(int index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) RevisionStatusFluent.this.setToInitContainerStatuses(index,builder.build());
    }
    
    public N endInitContainerStatus() {
      return and();
    }
    
  
  }

}