package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RouteListBuilder extends RouteListFluent<RouteListBuilder> implements VisitableBuilder<RouteList,RouteListBuilder>{
  public RouteListBuilder() {
    this(new RouteList());
  }
  
  public RouteListBuilder(RouteListFluent<?> fluent) {
    this(fluent, new RouteList());
  }
  
  public RouteListBuilder(RouteListFluent<?> fluent,RouteList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RouteListBuilder(RouteList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RouteListFluent<?> fluent;
  
  public RouteList build() {
    RouteList buildable = new RouteList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}