package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TrafficTargetBuilder extends TrafficTargetFluent<TrafficTargetBuilder> implements VisitableBuilder<TrafficTarget,TrafficTargetBuilder>{
  public TrafficTargetBuilder() {
    this(new TrafficTarget());
  }
  
  public TrafficTargetBuilder(TrafficTargetFluent<?> fluent) {
    this(fluent, new TrafficTarget());
  }
  
  public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,TrafficTarget instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TrafficTargetBuilder(TrafficTarget instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TrafficTargetFluent<?> fluent;
  
  public TrafficTarget build() {
    TrafficTarget buildable = new TrafficTarget(fluent.getConfigurationName(),fluent.getLatestRevision(),fluent.getPercent(),fluent.getRevisionName(),fluent.getTag(),fluent.getUrl());
    return buildable;
  }
  

}