package io.fabric8.knative.serving.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DomainMappingSpecFluent<A extends DomainMappingSpecFluent<A>> extends BaseFluent<A>{
  public DomainMappingSpecFluent() {
  }
  
  public DomainMappingSpecFluent(DomainMappingSpec instance) {
    this.copyInstance(instance);
  }
  private KReferenceBuilder ref;
  private SecretTLSBuilder tls;
  
  protected void copyInstance(DomainMappingSpec instance) {
    instance = (instance != null ? instance : new DomainMappingSpec());
  
    if (instance != null) {
        this.withRef(instance.getRef());
        this.withTls(instance.getTls());
        this.withRef(instance.getRef());
        this.withTls(instance.getTls());
      }
  }
  
  public KReference buildRef() {
    return this.ref!=null ?this.ref.build():null;
  }
  
  public A withRef(KReference ref) {
    _visitables.get("ref").remove(this.ref);
    if (ref!=null){ this.ref= new KReferenceBuilder(ref); _visitables.get("ref").add(this.ref);} else { this.ref = null; _visitables.get("ref").remove(this.ref); } return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public RefNested<A> withNewRef() {
    return new RefNested(null);
  }
  
  public RefNested<A> withNewRefLike(KReference item) {
    return new RefNested(item);
  }
  
  public RefNested<A> editRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(null));
  }
  
  public RefNested<A> editOrNewRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(new KReferenceBuilder().build()));
  }
  
  public RefNested<A> editOrNewRefLike(KReference item) {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(item));
  }
  
  public SecretTLS buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  
  public A withTls(SecretTLS tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new SecretTLSBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public A withNewTls(String secretName) {
    return (A)withTls(new SecretTLS(secretName));
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(SecretTLS item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new SecretTLSBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(SecretTLS item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DomainMappingSpecFluent that = (DomainMappingSpecFluent) o;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
  
    if (!java.util.Objects.equals(tls, that.tls)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ref,  tls,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class RefNested<N> extends KReferenceFluent<RefNested<N>> implements Nested<N>{
    RefNested(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    KReferenceBuilder builder;
    
    public N and() {
      return (N) DomainMappingSpecFluent.this.withRef(builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends SecretTLSFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(SecretTLS item) {
      this.builder = new SecretTLSBuilder(this, item);
    }
    SecretTLSBuilder builder;
    
    public N and() {
      return (N) DomainMappingSpecFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}