package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class APIVersionKindBuilder extends APIVersionKindFluent<APIVersionKindBuilder> implements VisitableBuilder<APIVersionKind,APIVersionKindBuilder>{
  public APIVersionKindBuilder() {
    this(new APIVersionKind());
  }
  
  public APIVersionKindBuilder(APIVersionKindFluent<?> fluent) {
    this(fluent, new APIVersionKind());
  }
  
  public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,APIVersionKind instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public APIVersionKindBuilder(APIVersionKind instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  APIVersionKindFluent<?> fluent;
  
  public APIVersionKind build() {
    APIVersionKind buildable = new APIVersionKind(fluent.getApiVersion(),fluent.getKind());
    return buildable;
  }
  

}