package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ApiServerSourceSpecBuilder extends ApiServerSourceSpecFluent<ApiServerSourceSpecBuilder> implements VisitableBuilder<ApiServerSourceSpec,ApiServerSourceSpecBuilder>{
  public ApiServerSourceSpecBuilder() {
    this(new ApiServerSourceSpec());
  }
  
  public ApiServerSourceSpecBuilder(ApiServerSourceSpecFluent<?> fluent) {
    this(fluent, new ApiServerSourceSpec());
  }
  
  public ApiServerSourceSpecBuilder(ApiServerSourceSpecFluent<?> fluent,ApiServerSourceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ApiServerSourceSpecBuilder(ApiServerSourceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ApiServerSourceSpecFluent<?> fluent;
  
  public ApiServerSourceSpec build() {
    ApiServerSourceSpec buildable = new ApiServerSourceSpec(fluent.buildCeOverrides(),fluent.getMode(),fluent.buildNamespaceSelector(),fluent.buildOwner(),fluent.buildResources(),fluent.getServiceAccountName(),fluent.buildSink());
    return buildable;
  }
  

}