package io.fabric8.knative.sources.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PingSourceSpecFluent<A extends PingSourceSpecFluent<A>> extends BaseFluent<A>{
  public PingSourceSpecFluent() {
  }
  
  public PingSourceSpecFluent(PingSourceSpec instance) {
    this.copyInstance(instance);
  }
  private CloudEventOverridesBuilder ceOverrides;
  private String contentType;
  private String data;
  private String dataBase64;
  private String schedule;
  private DestinationBuilder sink;
  private String timezone;
  
  protected void copyInstance(PingSourceSpec instance) {
    instance = (instance != null ? instance : new PingSourceSpec());
  
    if (instance != null) {
        this.withCeOverrides(instance.getCeOverrides());
        this.withContentType(instance.getContentType());
        this.withData(instance.getData());
        this.withDataBase64(instance.getDataBase64());
        this.withSchedule(instance.getSchedule());
        this.withSink(instance.getSink());
        this.withTimezone(instance.getTimezone());
        this.withCeOverrides(instance.getCeOverrides());
        this.withContentType(instance.getContentType());
        this.withData(instance.getData());
        this.withDataBase64(instance.getDataBase64());
        this.withSchedule(instance.getSchedule());
        this.withSink(instance.getSink());
        this.withTimezone(instance.getTimezone());
      }
  }
  
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  
  public boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  
  public CeOverridesNested<A> withNewCeOverrides() {
    return new CeOverridesNested(null);
  }
  
  public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new CeOverridesNested(item);
  }
  
  public CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(null));
  }
  
  public CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
  }
  
  public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(item));
  }
  
  public String getContentType() {
    return this.contentType;
  }
  
  public A withContentType(String contentType) {
    this.contentType=contentType; return (A) this;
  }
  
  public boolean hasContentType() {
    return this.contentType != null;
  }
  
  public String getData() {
    return this.data;
  }
  
  public A withData(String data) {
    this.data=data; return (A) this;
  }
  
  public boolean hasData() {
    return this.data != null;
  }
  
  public String getDataBase64() {
    return this.dataBase64;
  }
  
  public A withDataBase64(String dataBase64) {
    this.dataBase64=dataBase64; return (A) this;
  }
  
  public boolean hasDataBase64() {
    return this.dataBase64 != null;
  }
  
  public String getSchedule() {
    return this.schedule;
  }
  
  public A withSchedule(String schedule) {
    this.schedule=schedule; return (A) this;
  }
  
  public boolean hasSchedule() {
    return this.schedule != null;
  }
  
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Destination item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new DestinationBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public String getTimezone() {
    return this.timezone;
  }
  
  public A withTimezone(String timezone) {
    this.timezone=timezone; return (A) this;
  }
  
  public boolean hasTimezone() {
    return this.timezone != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PingSourceSpecFluent that = (PingSourceSpecFluent) o;
    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;
  
    if (!java.util.Objects.equals(contentType, that.contentType)) return false;
  
    if (!java.util.Objects.equals(data, that.data)) return false;
  
    if (!java.util.Objects.equals(dataBase64, that.dataBase64)) return false;
  
    if (!java.util.Objects.equals(schedule, that.schedule)) return false;
  
    if (!java.util.Objects.equals(sink, that.sink)) return false;
  
    if (!java.util.Objects.equals(timezone, that.timezone)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ceOverrides,  contentType,  data,  dataBase64,  schedule,  sink,  timezone,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (contentType != null) { sb.append("contentType:"); sb.append(contentType + ","); }
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (dataBase64 != null) { sb.append("dataBase64:"); sb.append(dataBase64 + ","); }
    if (schedule != null) { sb.append("schedule:"); sb.append(schedule + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (timezone != null) { sb.append("timezone:"); sb.append(timezone); }
    sb.append("}");
    return sb.toString();
  }
  public class CeOverridesNested<N> extends CloudEventOverridesFluent<CeOverridesNested<N>> implements Nested<N>{
    CeOverridesNested(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CloudEventOverridesBuilder builder;
    
    public N and() {
      return (N) PingSourceSpecFluent.this.withCeOverrides(builder.build());
    }
    
    public N endCeOverrides() {
      return and();
    }
    
  
  }
  public class SinkNested<N> extends DestinationFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) PingSourceSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }

}