package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SinkBindingBuilder extends SinkBindingFluent<SinkBindingBuilder> implements VisitableBuilder<SinkBinding,SinkBindingBuilder>{
  public SinkBindingBuilder() {
    this(new SinkBinding());
  }
  
  public SinkBindingBuilder(SinkBindingFluent<?> fluent) {
    this(fluent, new SinkBinding());
  }
  
  public SinkBindingBuilder(SinkBindingFluent<?> fluent,SinkBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SinkBindingBuilder(SinkBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SinkBindingFluent<?> fluent;
  
  public SinkBinding build() {
    SinkBinding buildable = new SinkBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}