package io.fabric8.knative.sources.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.tracker.Reference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.knative.internal.pkg.tracker.ReferenceFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SinkBindingSpecFluent<A extends SinkBindingSpecFluent<A>> extends BaseFluent<A>{
  public SinkBindingSpecFluent() {
  }
  
  public SinkBindingSpecFluent(SinkBindingSpec instance) {
    this.copyInstance(instance);
  }
  private CloudEventOverridesBuilder ceOverrides;
  private DestinationBuilder sink;
  private ReferenceBuilder subject;
  
  protected void copyInstance(SinkBindingSpec instance) {
    instance = (instance != null ? instance : new SinkBindingSpec());
  
    if (instance != null) {
        this.withCeOverrides(instance.getCeOverrides());
        this.withSink(instance.getSink());
        this.withSubject(instance.getSubject());
        this.withCeOverrides(instance.getCeOverrides());
        this.withSink(instance.getSink());
        this.withSubject(instance.getSubject());
      }
  }
  
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  
  public boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  
  public CeOverridesNested<A> withNewCeOverrides() {
    return new CeOverridesNested(null);
  }
  
  public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new CeOverridesNested(item);
  }
  
  public CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(null));
  }
  
  public CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
  }
  
  public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(item));
  }
  
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Destination item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new DestinationBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public Reference buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  
  public A withSubject(Reference subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new ReferenceBuilder(subject); _visitables.get("subject").add(this.subject);} else { this.subject = null; _visitables.get("subject").remove(this.subject); } return (A) this;
  }
  
  public boolean hasSubject() {
    return this.subject != null;
  }
  
  public SubjectNested<A> withNewSubject() {
    return new SubjectNested(null);
  }
  
  public SubjectNested<A> withNewSubjectLike(Reference item) {
    return new SubjectNested(item);
  }
  
  public SubjectNested<A> editSubject() {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(null));
  }
  
  public SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(new ReferenceBuilder().build()));
  }
  
  public SubjectNested<A> editOrNewSubjectLike(Reference item) {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SinkBindingSpecFluent that = (SinkBindingSpecFluent) o;
    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;
  
    if (!java.util.Objects.equals(sink, that.sink)) return false;
  
    if (!java.util.Objects.equals(subject, that.subject)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ceOverrides,  sink,  subject,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject); }
    sb.append("}");
    return sb.toString();
  }
  public class CeOverridesNested<N> extends CloudEventOverridesFluent<CeOverridesNested<N>> implements Nested<N>{
    CeOverridesNested(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CloudEventOverridesBuilder builder;
    
    public N and() {
      return (N) SinkBindingSpecFluent.this.withCeOverrides(builder.build());
    }
    
    public N endCeOverrides() {
      return and();
    }
    
  
  }
  public class SinkNested<N> extends DestinationFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) SinkBindingSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }
  public class SubjectNested<N> extends ReferenceFluent<SubjectNested<N>> implements Nested<N>{
    SubjectNested(Reference item) {
      this.builder = new ReferenceBuilder(this, item);
    }
    ReferenceBuilder builder;
    
    public N and() {
      return (N) SinkBindingSpecFluent.this.withSubject(builder.build());
    }
    
    public N endSubject() {
      return and();
    }
    
  
  }

}