package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaSourceSpecBuilder extends KafkaSourceSpecFluent<KafkaSourceSpecBuilder> implements VisitableBuilder<KafkaSourceSpec,KafkaSourceSpecBuilder>{
  public KafkaSourceSpecBuilder() {
    this(new KafkaSourceSpec());
  }
  
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent) {
    this(fluent, new KafkaSourceSpec());
  }
  
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaSourceSpecBuilder(KafkaSourceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaSourceSpecFluent<?> fluent;
  
  public KafkaSourceSpec build() {
    KafkaSourceSpec buildable = new KafkaSourceSpec(fluent.getBootstrapServers(),fluent.buildCeOverrides(),fluent.getConsumerGroup(),fluent.getConsumers(),fluent.buildDelivery(),fluent.getInitialOffset(),fluent.buildNet(),fluent.buildSink(),fluent.getTopics());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}