package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EventTypeSpecBuilder extends EventTypeSpecFluent<EventTypeSpecBuilder> implements VisitableBuilder<EventTypeSpec,EventTypeSpecBuilder>{
  public EventTypeSpecBuilder() {
    this(new EventTypeSpec());
  }
  
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent) {
    this(fluent, new EventTypeSpec());
  }
  
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EventTypeSpecBuilder(EventTypeSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EventTypeSpecFluent<?> fluent;
  
  public EventTypeSpec build() {
    EventTypeSpec buildable = new EventTypeSpec(fluent.getBroker(),fluent.getDescription(),fluent.getSchema(),fluent.getSchemaData(),fluent.getSource(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}