package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ParallelSpecFluent<A extends ParallelSpecFluent<A>> extends BaseFluent<A>{
  public ParallelSpecFluent() {
  }
  
  public ParallelSpecFluent(ParallelSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ParallelBranchBuilder> branches = new ArrayList<ParallelBranchBuilder>();
  private ChannelTemplateSpecBuilder channelTemplate;
  private DestinationBuilder reply;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ParallelSpec instance) {
    instance = (instance != null ? instance : new ParallelSpec());
    if (instance != null) {
          this.withBranches(instance.getBranches());
          this.withChannelTemplate(instance.getChannelTemplate());
          this.withReply(instance.getReply());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBranches(int index,ParallelBranch item) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
    if (index < 0 || index >= branches.size()) { _visitables.get("branches").add(builder); branches.add(builder); } else { _visitables.get("branches").add(index, builder); branches.add(index, builder);}
    return (A)this;
  }
  
  public A setToBranches(int index,ParallelBranch item) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
    if (index < 0 || index >= branches.size()) { _visitables.get("branches").add(builder); branches.add(builder); } else { _visitables.get("branches").set(index, builder); branches.set(index, builder);}
    return (A)this;
  }
  
  public A addToBranches(io.fabric8.knative.flows.v1.ParallelBranch... items) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
  }
  
  public A addAllToBranches(Collection<ParallelBranch> items) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
  }
  
  public A removeFromBranches(io.fabric8.knative.flows.v1.ParallelBranch... items) {
    if (this.branches == null) return (A)this;
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").remove(builder); this.branches.remove(builder);} return (A)this;
  }
  
  public A removeAllFromBranches(Collection<ParallelBranch> items) {
    if (this.branches == null) return (A)this;
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").remove(builder); this.branches.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromBranches(Predicate<ParallelBranchBuilder> predicate) {
    if (branches == null) return (A) this;
    final Iterator<ParallelBranchBuilder> each = branches.iterator();
    final List visitables = _visitables.get("branches");
    while (each.hasNext()) {
      ParallelBranchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ParallelBranch> buildBranches() {
    return this.branches != null ? build(branches) : null;
  }
  
  public ParallelBranch buildBranch(int index) {
    return this.branches.get(index).build();
  }
  
  public ParallelBranch buildFirstBranch() {
    return this.branches.get(0).build();
  }
  
  public ParallelBranch buildLastBranch() {
    return this.branches.get(branches.size() - 1).build();
  }
  
  public ParallelBranch buildMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
      for (ParallelBranchBuilder item : branches) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
      for (ParallelBranchBuilder item : branches) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBranches(List<ParallelBranch> branches) {
    if (this.branches != null) {
      this._visitables.get("branches").clear();
    }
    if (branches != null) {
        this.branches = new ArrayList();
        for (ParallelBranch item : branches) {
          this.addToBranches(item);
        }
    } else {
      this.branches = null;
    }
    return (A) this;
  }
  
  public A withBranches(io.fabric8.knative.flows.v1.ParallelBranch... branches) {
    if (this.branches != null) {
        this.branches.clear();
        _visitables.remove("branches");
    }
    if (branches != null) {
      for (ParallelBranch item : branches) {
        this.addToBranches(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBranches() {
    return this.branches != null && !this.branches.isEmpty();
  }
  
  public BranchesNested<A> addNewBranch() {
    return new BranchesNested(-1, null);
  }
  
  public BranchesNested<A> addNewBranchLike(ParallelBranch item) {
    return new BranchesNested(-1, item);
  }
  
  public BranchesNested<A> setNewBranchLike(int index,ParallelBranch item) {
    return new BranchesNested(index, item);
  }
  
  public BranchesNested<A> editBranch(int index) {
    if (branches.size() <= index) throw new RuntimeException("Can't edit branches. Index exceeds size.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  public BranchesNested<A> editFirstBranch() {
    if (branches.size() == 0) throw new RuntimeException("Can't edit first branches. The list is empty.");
    return setNewBranchLike(0, buildBranch(0));
  }
  
  public BranchesNested<A> editLastBranch() {
    int index = branches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last branches. The list is empty.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  public BranchesNested<A> editMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<branches.size();i++) { 
    if (predicate.test(branches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching branches. No match found.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  public ChannelTemplateSpec buildChannelTemplate() {
    return this.channelTemplate != null ? this.channelTemplate.build() : null;
  }
  
  public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
    this._visitables.remove("channelTemplate");
    if (channelTemplate != null) {
        this.channelTemplate = new ChannelTemplateSpecBuilder(channelTemplate);
        this._visitables.get("channelTemplate").add(this.channelTemplate);
    } else {
        this.channelTemplate = null;
        this._visitables.get("channelTemplate").remove(this.channelTemplate);
    }
    return (A) this;
  }
  
  public boolean hasChannelTemplate() {
    return this.channelTemplate != null;
  }
  
  public ChannelTemplateNested<A> withNewChannelTemplate() {
    return new ChannelTemplateNested(null);
  }
  
  public ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
    return new ChannelTemplateNested(item);
  }
  
  public ChannelTemplateNested<A> editChannelTemplate() {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(null));
  }
  
  public ChannelTemplateNested<A> editOrNewChannelTemplate() {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(new ChannelTemplateSpecBuilder().build()));
  }
  
  public ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
    return withNewChannelTemplateLike(java.util.Optional.ofNullable(buildChannelTemplate()).orElse(item));
  }
  
  public Destination buildReply() {
    return this.reply != null ? this.reply.build() : null;
  }
  
  public A withReply(Destination reply) {
    this._visitables.remove("reply");
    if (reply != null) {
        this.reply = new DestinationBuilder(reply);
        this._visitables.get("reply").add(this.reply);
    } else {
        this.reply = null;
        this._visitables.get("reply").remove(this.reply);
    }
    return (A) this;
  }
  
  public boolean hasReply() {
    return this.reply != null;
  }
  
  public ReplyNested<A> withNewReply() {
    return new ReplyNested(null);
  }
  
  public ReplyNested<A> withNewReplyLike(Destination item) {
    return new ReplyNested(item);
  }
  
  public ReplyNested<A> editReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(null));
  }
  
  public ReplyNested<A> editOrNewReply() {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(new DestinationBuilder().build()));
  }
  
  public ReplyNested<A> editOrNewReplyLike(Destination item) {
    return withNewReplyLike(java.util.Optional.ofNullable(buildReply()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ParallelSpecFluent that = (ParallelSpecFluent) o;
    if (!java.util.Objects.equals(branches, that.branches)) return false;
    if (!java.util.Objects.equals(channelTemplate, that.channelTemplate)) return false;
    if (!java.util.Objects.equals(reply, that.reply)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(branches,  channelTemplate,  reply,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (branches != null && !branches.isEmpty()) { sb.append("branches:"); sb.append(branches + ","); }
    if (channelTemplate != null) { sb.append("channelTemplate:"); sb.append(channelTemplate + ","); }
    if (reply != null) { sb.append("reply:"); sb.append(reply + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BranchesNested<N> extends ParallelBranchFluent<BranchesNested<N>> implements Nested<N>{
    BranchesNested(int index,ParallelBranch item) {
      this.index = index;
      this.builder = new ParallelBranchBuilder(this, item);
    }
    ParallelBranchBuilder builder;
    int index;
    
    public N and() {
      return (N) ParallelSpecFluent.this.setToBranches(index,builder.build());
    }
    
    public N endBranch() {
      return and();
    }
    
  
  }
  public class ChannelTemplateNested<N> extends ChannelTemplateSpecFluent<ChannelTemplateNested<N>> implements Nested<N>{
    ChannelTemplateNested(ChannelTemplateSpec item) {
      this.builder = new ChannelTemplateSpecBuilder(this, item);
    }
    ChannelTemplateSpecBuilder builder;
    
    public N and() {
      return (N) ParallelSpecFluent.this.withChannelTemplate(builder.build());
    }
    
    public N endChannelTemplate() {
      return and();
    }
    
  
  }
  public class ReplyNested<N> extends DestinationFluent<ReplyNested<N>> implements Nested<N>{
    ReplyNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) ParallelSpecFluent.this.withReply(builder.build());
    }
    
    public N endReply() {
      return and();
    }
    
  
  }

}