package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ParallelStatusBuilder extends ParallelStatusFluent<ParallelStatusBuilder> implements VisitableBuilder<ParallelStatus,ParallelStatusBuilder>{
  public ParallelStatusBuilder() {
    this(new ParallelStatus());
  }
  
  public ParallelStatusBuilder(ParallelStatusFluent<?> fluent) {
    this(fluent, new ParallelStatus());
  }
  
  public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,ParallelStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ParallelStatusBuilder(ParallelStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ParallelStatusFluent<?> fluent;
  
  public ParallelStatus build() {
    ParallelStatus buildable = new ParallelStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildBranchStatuses(),fluent.buildConditions(),fluent.buildIngressChannelStatus(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}