package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SequenceStepFluent<A extends SequenceStepFluent<A>> extends BaseFluent<A>{
  public SequenceStepFluent() {
  }
  
  public SequenceStepFluent(SequenceStep instance) {
    this.copyInstance(instance);
  }
  private String cACerts;
  private DeliverySpecBuilder delivery;
  private KReferenceBuilder ref;
  private String uri;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SequenceStep instance) {
    instance = (instance != null ? instance : new SequenceStep());
    if (instance != null) {
          this.withCACerts(instance.getCACerts());
          this.withDelivery(instance.getDelivery());
          this.withRef(instance.getRef());
          this.withUri(instance.getUri());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCACerts() {
    return this.cACerts;
  }
  
  public A withCACerts(String cACerts) {
    this.cACerts = cACerts;
    return (A) this;
  }
  
  public boolean hasCACerts() {
    return this.cACerts != null;
  }
  
  public DeliverySpec buildDelivery() {
    return this.delivery != null ? this.delivery.build() : null;
  }
  
  public A withDelivery(DeliverySpec delivery) {
    this._visitables.remove("delivery");
    if (delivery != null) {
        this.delivery = new DeliverySpecBuilder(delivery);
        this._visitables.get("delivery").add(this.delivery);
    } else {
        this.delivery = null;
        this._visitables.get("delivery").remove(this.delivery);
    }
    return (A) this;
  }
  
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  
  public KReference buildRef() {
    return this.ref != null ? this.ref.build() : null;
  }
  
  public A withRef(KReference ref) {
    this._visitables.remove("ref");
    if (ref != null) {
        this.ref = new KReferenceBuilder(ref);
        this._visitables.get("ref").add(this.ref);
    } else {
        this.ref = null;
        this._visitables.get("ref").remove(this.ref);
    }
    return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public RefNested<A> withNewRef() {
    return new RefNested(null);
  }
  
  public RefNested<A> withNewRefLike(KReference item) {
    return new RefNested(item);
  }
  
  public RefNested<A> editRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(null));
  }
  
  public RefNested<A> editOrNewRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(new KReferenceBuilder().build()));
  }
  
  public RefNested<A> editOrNewRefLike(KReference item) {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(item));
  }
  
  public String getUri() {
    return this.uri;
  }
  
  public A withUri(String uri) {
    this.uri = uri;
    return (A) this;
  }
  
  public boolean hasUri() {
    return this.uri != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SequenceStepFluent that = (SequenceStepFluent) o;
    if (!java.util.Objects.equals(cACerts, that.cACerts)) return false;
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
    if (!java.util.Objects.equals(uri, that.uri)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cACerts,  delivery,  ref,  uri,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cACerts != null) { sb.append("cACerts:"); sb.append(cACerts + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    
    public N and() {
      return (N) SequenceStepFluent.this.withDelivery(builder.build());
    }
    
    public N endDelivery() {
      return and();
    }
    
  
  }
  public class RefNested<N> extends KReferenceFluent<RefNested<N>> implements Nested<N>{
    RefNested(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    KReferenceBuilder builder;
    
    public N and() {
      return (N) SequenceStepFluent.this.withRef(builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }

}