package io.fabric8.knative.internal.pkg.apis.duck.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DestinationFluent<A extends DestinationFluent<A>> extends BaseFluent<A>{
  public DestinationFluent() {
  }
  
  public DestinationFluent(Destination instance) {
    this.copyInstance(instance);
  }
  private String cACerts;
  private KReferenceBuilder ref;
  private String uri;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Destination instance) {
    instance = (instance != null ? instance : new Destination());
    if (instance != null) {
          this.withCACerts(instance.getCACerts());
          this.withRef(instance.getRef());
          this.withUri(instance.getUri());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCACerts() {
    return this.cACerts;
  }
  
  public A withCACerts(String cACerts) {
    this.cACerts = cACerts;
    return (A) this;
  }
  
  public boolean hasCACerts() {
    return this.cACerts != null;
  }
  
  public KReference buildRef() {
    return this.ref != null ? this.ref.build() : null;
  }
  
  public A withRef(KReference ref) {
    this._visitables.remove("ref");
    if (ref != null) {
        this.ref = new KReferenceBuilder(ref);
        this._visitables.get("ref").add(this.ref);
    } else {
        this.ref = null;
        this._visitables.get("ref").remove(this.ref);
    }
    return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public RefNested<A> withNewRef() {
    return new RefNested(null);
  }
  
  public RefNested<A> withNewRefLike(KReference item) {
    return new RefNested(item);
  }
  
  public RefNested<A> editRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(null));
  }
  
  public RefNested<A> editOrNewRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(new KReferenceBuilder().build()));
  }
  
  public RefNested<A> editOrNewRefLike(KReference item) {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(item));
  }
  
  public String getUri() {
    return this.uri;
  }
  
  public A withUri(String uri) {
    this.uri = uri;
    return (A) this;
  }
  
  public boolean hasUri() {
    return this.uri != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DestinationFluent that = (DestinationFluent) o;
    if (!java.util.Objects.equals(cACerts, that.cACerts)) return false;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
    if (!java.util.Objects.equals(uri, that.uri)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cACerts,  ref,  uri,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cACerts != null) { sb.append("cACerts:"); sb.append(cACerts + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RefNested<N> extends KReferenceFluent<RefNested<N>> implements Nested<N>{
    RefNested(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    KReferenceBuilder builder;
    
    public N and() {
      return (N) DestinationFluent.this.withRef(builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }

}