/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.flows.v1;

import io.fabric8.knative.flows.v1.ParallelBranchStatus;
import io.fabric8.knative.flows.v1.ParallelBranchStatusBuilder;
import io.fabric8.knative.flows.v1.ParallelBranchStatusFluent;
import io.fabric8.knative.flows.v1.ParallelChannelStatus;
import io.fabric8.knative.flows.v1.ParallelChannelStatusBuilder;
import io.fabric8.knative.flows.v1.ParallelChannelStatusFluent;
import io.fabric8.knative.flows.v1.ParallelStatus;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ParallelStatusFluent<A extends ParallelStatusFluent<A>>
extends BaseFluent<A> {
    private AddressableBuilder address;
    private ArrayList<AddressableBuilder> addresses = new ArrayList();
    private Map<String, String> annotations;
    private ArrayList<ParallelBranchStatusBuilder> branchStatuses = new ArrayList();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private ParallelChannelStatusBuilder ingressChannelStatus;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public ParallelStatusFluent() {
    }

    public ParallelStatusFluent(ParallelStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ParallelStatus instance) {
        ParallelStatus parallelStatus = instance = instance != null ? instance : new ParallelStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAddresses(instance.getAddresses());
            this.withAnnotations(instance.getAnnotations());
            this.withBranchStatuses(instance.getBranchStatuses());
            this.withConditions(instance.getConditions());
            this.withIngressChannelStatus(instance.getIngressChannelStatus());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    public A withAddress(Addressable address) {
        this._visitables.remove((Object)"address");
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove((Object)this.address);
        }
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String cACerts, String name, String url) {
        return this.withAddress(new Addressable(cACerts, name, url));
    }

    public AddressNested<A> withNewAddress() {
        return new AddressNested(null);
    }

    public AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNested(item);
    }

    public AddressNested<A> editAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(null));
    }

    public AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(new AddressableBuilder().build()));
    }

    public AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(item));
    }

    public A addToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(Addressable ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(Addressable ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<AddressableBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<AddressableBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            AddressableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Addressable> buildAddresses() {
        return this.addresses != null ? ParallelStatusFluent.build(this.addresses) : null;
    }

    public Addressable buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public Addressable buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public Addressable buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public Addressable buildMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<Addressable> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(Addressable ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String cACerts, String name, String url) {
        return this.addToAddresses(new Addressable(cACerts, name, url));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(Addressable item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, Addressable item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<AddressableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToBranchStatuses(int index, ParallelBranchStatus item) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
        if (index < 0 || index >= this.branchStatuses.size()) {
            this._visitables.get((Object)"branchStatuses").add(builder);
            this.branchStatuses.add(builder);
        } else {
            this._visitables.get((Object)"branchStatuses").add(index, builder);
            this.branchStatuses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBranchStatuses(int index, ParallelBranchStatus item) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
        if (index < 0 || index >= this.branchStatuses.size()) {
            this._visitables.get((Object)"branchStatuses").add(builder);
            this.branchStatuses.add(builder);
        } else {
            this._visitables.get((Object)"branchStatuses").set(index, builder);
            this.branchStatuses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBranchStatuses(ParallelBranchStatus ... items) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").add(builder);
            this.branchStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBranchStatuses(Collection<ParallelBranchStatus> items) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").add(builder);
            this.branchStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBranchStatuses(ParallelBranchStatus ... items) {
        if (this.branchStatuses == null) {
            return (A)((Object)this);
        }
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").remove((Object)builder);
            this.branchStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBranchStatuses(Collection<ParallelBranchStatus> items) {
        if (this.branchStatuses == null) {
            return (A)((Object)this);
        }
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").remove((Object)builder);
            this.branchStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBranchStatuses(Predicate<ParallelBranchStatusBuilder> predicate) {
        if (this.branchStatuses == null) {
            return (A)((Object)this);
        }
        Iterator<ParallelBranchStatusBuilder> each = this.branchStatuses.iterator();
        List visitables = this._visitables.get((Object)"branchStatuses");
        while (each.hasNext()) {
            ParallelBranchStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ParallelBranchStatus> buildBranchStatuses() {
        return this.branchStatuses != null ? ParallelStatusFluent.build(this.branchStatuses) : null;
    }

    public ParallelBranchStatus buildBranchStatus(int index) {
        return this.branchStatuses.get(index).build();
    }

    public ParallelBranchStatus buildFirstBranchStatus() {
        return this.branchStatuses.get(0).build();
    }

    public ParallelBranchStatus buildLastBranchStatus() {
        return this.branchStatuses.get(this.branchStatuses.size() - 1).build();
    }

    public ParallelBranchStatus buildMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
        for (ParallelBranchStatusBuilder item : this.branchStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
        for (ParallelBranchStatusBuilder item : this.branchStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBranchStatuses(List<ParallelBranchStatus> branchStatuses) {
        if (this.branchStatuses != null) {
            this._visitables.get((Object)"branchStatuses").clear();
        }
        if (branchStatuses != null) {
            this.branchStatuses = new ArrayList();
            for (ParallelBranchStatus item : branchStatuses) {
                this.addToBranchStatuses(item);
            }
        } else {
            this.branchStatuses = null;
        }
        return (A)((Object)this);
    }

    public A withBranchStatuses(ParallelBranchStatus ... branchStatuses) {
        if (this.branchStatuses != null) {
            this.branchStatuses.clear();
            this._visitables.remove((Object)"branchStatuses");
        }
        if (branchStatuses != null) {
            for (ParallelBranchStatus item : branchStatuses) {
                this.addToBranchStatuses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBranchStatuses() {
        return this.branchStatuses != null && !this.branchStatuses.isEmpty();
    }

    public BranchStatusesNested<A> addNewBranchStatus() {
        return new BranchStatusesNested(-1, null);
    }

    public BranchStatusesNested<A> addNewBranchStatusLike(ParallelBranchStatus item) {
        return new BranchStatusesNested(-1, item);
    }

    public BranchStatusesNested<A> setNewBranchStatusLike(int index, ParallelBranchStatus item) {
        return new BranchStatusesNested(index, item);
    }

    public BranchStatusesNested<A> editBranchStatus(int index) {
        if (this.branchStatuses.size() <= index) {
            throw new RuntimeException("Can't edit branchStatuses. Index exceeds size.");
        }
        return this.setNewBranchStatusLike(index, this.buildBranchStatus(index));
    }

    public BranchStatusesNested<A> editFirstBranchStatus() {
        if (this.branchStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first branchStatuses. The list is empty.");
        }
        return this.setNewBranchStatusLike(0, this.buildBranchStatus(0));
    }

    public BranchStatusesNested<A> editLastBranchStatus() {
        int index = this.branchStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last branchStatuses. The list is empty.");
        }
        return this.setNewBranchStatusLike(index, this.buildBranchStatus(index));
    }

    public BranchStatusesNested<A> editMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.branchStatuses.size(); ++i) {
            if (!predicate.test(this.branchStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching branchStatuses. No match found.");
        }
        return this.setNewBranchStatusLike(index, this.buildBranchStatus(index));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? ParallelStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ParallelChannelStatus buildIngressChannelStatus() {
        return this.ingressChannelStatus != null ? this.ingressChannelStatus.build() : null;
    }

    public A withIngressChannelStatus(ParallelChannelStatus ingressChannelStatus) {
        this._visitables.remove((Object)"ingressChannelStatus");
        if (ingressChannelStatus != null) {
            this.ingressChannelStatus = new ParallelChannelStatusBuilder(ingressChannelStatus);
            this._visitables.get((Object)"ingressChannelStatus").add(this.ingressChannelStatus);
        } else {
            this.ingressChannelStatus = null;
            this._visitables.get((Object)"ingressChannelStatus").remove((Object)this.ingressChannelStatus);
        }
        return (A)((Object)this);
    }

    public boolean hasIngressChannelStatus() {
        return this.ingressChannelStatus != null;
    }

    public IngressChannelStatusNested<A> withNewIngressChannelStatus() {
        return new IngressChannelStatusNested(null);
    }

    public IngressChannelStatusNested<A> withNewIngressChannelStatusLike(ParallelChannelStatus item) {
        return new IngressChannelStatusNested(item);
    }

    public IngressChannelStatusNested<A> editIngressChannelStatus() {
        return this.withNewIngressChannelStatusLike(Optional.ofNullable(this.buildIngressChannelStatus()).orElse(null));
    }

    public IngressChannelStatusNested<A> editOrNewIngressChannelStatus() {
        return this.withNewIngressChannelStatusLike(Optional.ofNullable(this.buildIngressChannelStatus()).orElse(new ParallelChannelStatusBuilder().build()));
    }

    public IngressChannelStatusNested<A> editOrNewIngressChannelStatusLike(ParallelChannelStatus item) {
        return this.withNewIngressChannelStatusLike(Optional.ofNullable(this.buildIngressChannelStatus()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParallelStatusFluent that = (ParallelStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.address, (Object)that.address)) {
            return false;
        }
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.branchStatuses, that.branchStatuses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.ingressChannelStatus, (Object)that.ingressChannelStatus)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.addresses, this.annotations, this.branchStatuses, this.conditions, this.ingressChannelStatus, this.observedGeneration, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append((Object)((Object)this.address) + ",");
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.branchStatuses != null && !this.branchStatuses.isEmpty()) {
            sb.append("branchStatuses:");
            sb.append(this.branchStatuses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.ingressChannelStatus != null) {
            sb.append("ingressChannelStatus:");
            sb.append((Object)((Object)this.ingressChannelStatus) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressChannelStatusNested<N>
    extends ParallelChannelStatusFluent<IngressChannelStatusNested<N>>
    implements Nested<N> {
        ParallelChannelStatusBuilder builder;

        IngressChannelStatusNested(ParallelChannelStatus item) {
            this.builder = new ParallelChannelStatusBuilder(this, item);
        }

        public N and() {
            return (N)ParallelStatusFluent.this.withIngressChannelStatus(this.builder.build());
        }

        public N endIngressChannelStatus() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)ParallelStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class BranchStatusesNested<N>
    extends ParallelBranchStatusFluent<BranchStatusesNested<N>>
    implements Nested<N> {
        ParallelBranchStatusBuilder builder;
        int index;

        BranchStatusesNested(int index, ParallelBranchStatus item) {
            this.index = index;
            this.builder = new ParallelBranchStatusBuilder(this, item);
        }

        public N and() {
            return (N)ParallelStatusFluent.this.setToBranchStatuses(this.index, this.builder.build());
        }

        public N endBranchStatus() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends AddressableFluent<AddressesNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;
        int index;

        AddressesNested(int index, Addressable item) {
            this.index = index;
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)ParallelStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }

    public class AddressNested<N>
    extends AddressableFluent<AddressNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;

        AddressNested(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)ParallelStatusFluent.this.withAddress(this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

