/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.duck.v1;

import io.fabric8.knative.duck.v1.AuthStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AuthStatusFluent<A extends AuthStatusFluent<A>>
extends BaseFluent<A> {
    private String serviceAccountName;
    private List<String> serviceAccountNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public AuthStatusFluent() {
    }

    public AuthStatusFluent(AuthStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AuthStatus instance) {
        AuthStatus authStatus = instance = instance != null ? instance : new AuthStatus();
        if (instance != null) {
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withServiceAccountNames(instance.getServiceAccountNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A addToServiceAccountNames(int index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToServiceAccountNames(int index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceAccountNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceAccountNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    public String getServiceAccountName(int index) {
        return this.serviceAccountNames.get(index);
    }

    public String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    public String getLastServiceAccountName() {
        return this.serviceAccountNames.get(this.serviceAccountNames.size() - 1);
    }

    public String getMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceAccountNames(List<String> serviceAccountNames) {
        if (serviceAccountNames != null) {
            this.serviceAccountNames = new ArrayList<String>();
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        } else {
            this.serviceAccountNames = null;
        }
        return (A)((Object)this);
    }

    public A withServiceAccountNames(String ... serviceAccountNames) {
        if (this.serviceAccountNames != null) {
            this.serviceAccountNames.clear();
            this._visitables.remove((Object)"serviceAccountNames");
        }
        if (serviceAccountNames != null) {
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccountNames() {
        return this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthStatusFluent that = (AuthStatusFluent)((Object)o);
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountNames, that.serviceAccountNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.serviceAccountName, this.serviceAccountNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty()) {
            sb.append("serviceAccountNames:");
            sb.append(this.serviceAccountNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

