/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.binary.repo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.binary.OSInfo;
import io.fabric8.kubeapitest.binary.repo.ObjectList;
import io.fabric8.kubeapitest.binary.repo.ObjectListItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRepo {
    private static final Logger log = LoggerFactory.getLogger(BinaryRepo.class);
    private final OSInfo osInfo;
    private static List<String> objectNames;
    private static final ReentrantLock downloadLock;

    public BinaryRepo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public File downloadVersionToTempFile(String version) {
        try {
            String url = "https://storage.googleapis.com/kubebuilder-tools/kubebuilder-tools-" + version + "-" + this.osInfo.getOSName() + "-" + this.osInfo.getOSArch() + ".tar.gz";
            File tempFile = File.createTempFile("kubebuilder-tools-" + version, ".tar.gz");
            log.debug("Downloading binary from url: {} to Temp file: {}", (Object)url, (Object)tempFile.getPath());
            this.copyURLToFile(url, tempFile);
            return tempFile;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
    }

    private void copyURLToFile(String url, File tempFile) throws IOException {
        try (InputStream in = new URL(url).openStream();){
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public Stream<String> listObjectNames() {
        downloadLock.lock();
        try {
            Stream<String> httpClient;
            if (objectNames == null) {
                log.debug("Listing objects from storage");
                httpClient = HttpClient.newBuilder().build();
                HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://storage.googleapis.com/storage/v1/b/kubebuilder-tools/o")).build();
                String response = ((HttpClient)((Object)httpClient)).send(request, HttpResponse.BodyHandlers.ofString()).body();
                ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                ObjectList objectList = (ObjectList)mapper.readValue(response, ObjectList.class);
                objectNames = objectList.getItems().stream().map(ObjectListItem::getName).collect(Collectors.toList());
            }
            httpClient = objectNames.stream();
            return httpClient;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KubeAPITestException(e);
        }
        finally {
            downloadLock.unlock();
        }
    }

    static {
        downloadLock = new ReentrantLock();
    }
}

