/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.cert;

import io.fabric8.kubeapitest.KubeAPITestException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertManager {
    private static final Logger log = LoggerFactory.getLogger(CertManager.class);
    public static final String API_SERVER_KEY_NAME = "apiserver.key";
    public static final String API_SERVER_CERT_NAME = "apiserver.crt";
    public static final String CLIENT_KEY_NAME = "client.key";
    public static final String CLIENT_CERT_NAME = "client.crt";
    private static final ReentrantLock generatorLock = new ReentrantLock();
    private final String kubeAPITestDir;

    public CertManager(String kubeAPITestDir) {
        this.kubeAPITestDir = kubeAPITestDir;
    }

    public void createCertificatesIfNeeded() {
        if (this.certFilesPresent()) {
            return;
        }
        generatorLock.lock();
        try {
            if (this.certFilesPresent()) {
                return;
            }
            this.generateAPIServerCertificates();
            this.generateUserCertificates();
        }
        finally {
            generatorLock.unlock();
        }
    }

    private boolean certFilesPresent() {
        File apiCert = new File(this.kubeAPITestDir, API_SERVER_CERT_NAME);
        File apiKey = new File(this.kubeAPITestDir, API_SERVER_KEY_NAME);
        File clientCert = new File(this.kubeAPITestDir, CLIENT_CERT_NAME);
        File clientKey = new File(this.kubeAPITestDir, CLIENT_KEY_NAME);
        return apiCert.exists() && apiKey.exists() && clientCert.exists() && clientKey.exists();
    }

    private void generateAPIServerCertificates() {
        log.info("Generating API Server certificates");
        CertManager.generateKeyAndCertificate("CN=example.org", new File(this.kubeAPITestDir, API_SERVER_KEY_NAME), new File(this.kubeAPITestDir, API_SERVER_CERT_NAME), new GeneralName(7, "127.0.0.1"), this.dns("kubernetes"), this.dns("kubernetes.default"), this.dns("kubernetes.default.svc"), this.dns("kubernetes.default.svc.cluster"), this.dns("kubernetes.default.svc.cluster.local"));
    }

    private GeneralName dns(String dns) {
        return new GeneralName(2, dns);
    }

    private void generateUserCertificates() {
        log.info("Generating Client certificates");
        CertManager.generateKeyAndCertificate("O=system:masters,CN=kubeapitest", new File(this.kubeAPITestDir, CLIENT_KEY_NAME), new File(this.kubeAPITestDir, CLIENT_CERT_NAME), new GeneralName[0]);
    }

    public static void generateKeyAndCertificate(String dirName, File keyFile, File certFile, GeneralName ... generalNames) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            KeyPair certKeyPair = keyGen.generateKeyPair();
            X500Name name = new X500Name(dirName);
            BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
            Instant validFrom = Instant.now();
            Instant validUntil = validFrom.plus(365L, ChronoUnit.DAYS);
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(name, serialNumber, Date.from(validFrom), Date.from(validUntil), name, certKeyPair.getPublic());
            if (generalNames.length > 0) {
                builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(generalNames));
            }
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").build(certKeyPair.getPrivate());
            X509CertificateHolder certHolder = builder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
            try (FileWriter certWriter = new FileWriter(certFile);
                 JcaPEMWriter certPemWriter = new JcaPEMWriter((Writer)certWriter);
                 FileWriter keyWriter = new FileWriter(keyFile);
                 JcaPEMWriter keyPemWriter = new JcaPEMWriter((Writer)keyWriter);){
                certPemWriter.writeObject((Object)cert);
                keyPemWriter.writeObject((Object)certKeyPair.getPrivate());
            }
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
            throw new KubeAPITestException(e);
        }
    }

    public String getClientCertPath() {
        return new File(this.kubeAPITestDir, CLIENT_CERT_NAME).getAbsolutePath();
    }

    public String getClientKeyPath() {
        return new File(this.kubeAPITestDir, CLIENT_KEY_NAME).getAbsolutePath();
    }

    public String getAPIServerKeyPath() {
        return new File(this.kubeAPITestDir, API_SERVER_KEY_NAME).getAbsolutePath();
    }

    public String getAPIServerCertPath() {
        return new File(this.kubeAPITestDir, API_SERVER_CERT_NAME).getAbsolutePath();
    }
}

