/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.mbeans.AppViewDetails;
import io.fabric8.kubernetes.api.mbeans.NamespaceAndAppPath;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppViewSnapshot {
    private final Map<NamespaceAndAppPath, AppViewDetails> appMap = new HashMap<NamespaceAndAppPath, AppViewDetails>();
    private final List<AppViewDetails> apps = new ArrayList<AppViewDetails>();
    private final Map<String, Service> servicesMap;
    private final Map<String, ReplicationController> controllerMap;
    private final Map<String, Pod> podMap;

    public AppViewSnapshot(Map<String, Service> servicesMap, Map<String, ReplicationController> controllerMap, Map<String, Pod> podMap) {
        this.servicesMap = servicesMap;
        this.controllerMap = controllerMap;
        this.podMap = podMap;
    }

    public AppViewDetails getOrCreateAppView(String appPath, String namespace) {
        NamespaceAndAppPath key = new NamespaceAndAppPath(namespace, appPath);
        AppViewDetails answer = this.appMap.get(key);
        if (answer == null) {
            answer = new AppViewDetails(this, appPath, namespace);
            this.appMap.put(key, answer);
            this.apps.add(answer);
        }
        return answer;
    }

    public List<AppViewDetails> getApps() {
        return this.apps;
    }

    public AppViewDetails createApp(String namespace) {
        AppViewDetails answer = new AppViewDetails(this, null, namespace);
        this.apps.add(answer);
        return answer;
    }

    public Map<NamespaceAndAppPath, AppViewDetails> getAppMap() {
        return this.appMap;
    }

    public Map<String, ReplicationController> getControllerMap() {
        return this.controllerMap;
    }

    public Map<String, Pod> getPodMap() {
        return this.podMap;
    }

    public Map<String, Service> getServicesMap() {
        return this.servicesMap;
    }

    public List<Pod> podsForReplicationController(ReplicationController controller) {
        return KubernetesHelper.getPodsForReplicationController(controller, this.podMap.values());
    }
}

