/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Details;
import io.fabric8.kubernetes.api.model.ErrorSchema;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;

public abstract class AbstractErrorSchemaAssert<S extends AbstractErrorSchemaAssert<S, A>, A extends ErrorSchema>
extends AbstractAssert<S, A> {
    protected AbstractErrorSchemaAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ErrorSchema)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasApiVersion(String apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualApiVersion = ((ErrorSchema)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)actualApiVersion, (Object)apiVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasCode(Double code, Double offset) {
        this.isNotNull();
        Double actualCode = ((ErrorSchema)this.actual).getCode();
        String assertjErrorMessage = String.format("\nExpected code:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>", actualCode, code, offset, Math.abs(code - actualCode));
        ((AbstractDoubleAssert)Assertions.assertThat((Double)actualCode).overridingErrorMessage(assertjErrorMessage, new Object[0])).isCloseTo(code, Assertions.within((Double)offset));
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasCreationTimestamp(Object creationTimestamp) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Object actualCreationTimestamp = ((ErrorSchema)this.actual).getCreationTimestamp();
        if (!Objects.areEqual((Object)actualCreationTimestamp, (Object)creationTimestamp)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, creationTimestamp, actualCreationTimestamp});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasDetails(Details details) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected details of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Details actualDetails = ((ErrorSchema)this.actual).getDetails();
        if (!Objects.areEqual((Object)actualDetails, (Object)details)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, details, actualDetails});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((ErrorSchema)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasMessage(String message) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualMessage = ((ErrorSchema)this.actual).getMessage();
        if (!Objects.areEqual((Object)actualMessage, (Object)message)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, message, actualMessage});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasReason(String reason) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualReason = ((ErrorSchema)this.actual).getReason();
        if (!Objects.areEqual((Object)actualReason, (Object)reason)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, reason, actualReason});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }

    public S hasStatus(String status) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualStatus = ((ErrorSchema)this.actual).getStatus();
        if (!Objects.areEqual((Object)actualStatus, (Object)status)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, status, actualStatus});
        }
        return (S)((Object)((AbstractErrorSchemaAssert)this.myself));
    }
}

