/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert;
import io.fabric8.kubernetes.assertions.HasPodSelectionAssert;
import io.fabric8.kubernetes.assertions.PodSelectionAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.ArrayList;
import java.util.Map;

public class ReplicationControllerPodsAssert
extends ReplicationControllerAssert
implements HasPodSelectionAssert {
    private final KubernetesClient client;

    public ReplicationControllerPodsAssert(KubernetesClient client, ReplicationController replicationController) {
        super(replicationController);
        this.client = client;
    }

    @Override
    public PodSelectionAssert pods() {
        ((ReplicationControllerSpecAssert)this.spec().isNotNull()).selector().isNotNull();
        ReplicationControllerSpec spec = ((ReplicationController)this.actual).getSpec();
        Integer replicas = spec.getReplicas();
        Map<String, String> matchLabels = spec.getSelector();
        ArrayList<LabelSelectorRequirement> matchExpressions = new ArrayList<LabelSelectorRequirement>();
        return new PodSelectionAssert(this.client, replicas, matchLabels, matchExpressions, "ReplicationController " + KubernetesHelper.getName((HasMetadata)((HasMetadata)this.actual)));
    }
}

