/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.client.utils.CommonThreadPool;
import io.fabric8.kubernetes.client.utils.Utils;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class LeaderElectorTest {
    LeaderElectorTest() {
    }

    @Test
    void runShouldAbortAfterRenewDeadlineExpired() throws Exception {
        Long renewDeadlineMillis = 1000L;
        LeaderElectionConfig lec = this.mockLeaderElectionConfiguration();
        Mockito.when((Object)lec.getRenewDeadline()).thenReturn((Object)Duration.ofMillis(renewDeadlineMillis));
        Lock mockedLock = lec.getLock();
        ((Lock)Mockito.doNothing().doAnswer(invocation -> {
            Thread.sleep(renewDeadlineMillis * 2L);
            throw new KubernetesClientException("");
        }).when((Object)mockedLock)).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        CompletableFuture future = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, (Executor)CommonThreadPool.get()).start();
        future.get(10L, TimeUnit.SECONDS);
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).get((KubernetesClient)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.times((int)1))).create((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.atLeast((int)1))).onNewLeader((String)ArgumentMatchers.eq((Object)"1337"));
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStartLeading();
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStopLeading();
    }

    @Test
    void runShouldEndlesslyRun() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CountDownLatch signal = new CountDownLatch(1);
        LeaderElectionConfig lec = this.mockLeaderElectionConfiguration();
        Lock mockedLock = lec.getLock();
        ((Lock)Mockito.doNothing().doThrow(new Throwable[]{new KubernetesClientException("Exception won't affect execution")}).doNothing().doAnswer(invocation -> {
            signal.countDown();
            return null;
        }).when((Object)mockedLock)).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        LeaderElector le = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, (Executor)CommonThreadPool.get());
        executor.submit(() -> ((LeaderElector)le).run());
        signal.await(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)signal.getCount());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).get((KubernetesClient)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.times((int)1))).create((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.atLeast((int)1))).onNewLeader((String)ArgumentMatchers.eq((Object)"1337"));
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStartLeading();
        Assertions.assertThrows(IllegalStateException.class, () -> ((LeaderElector)le).run());
        executor.shutdownNow();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStopLeading();
    }

    @Test
    void shouldReleaseWhenCanceled() throws Exception {
        AtomicReference<LeaderElectionRecord> activeLer = new AtomicReference<LeaderElectionRecord>();
        LeaderElectionConfig lec = this.mockLeaderElectionConfiguration(activeLer);
        CountDownLatch signal = new CountDownLatch(1);
        Lock mockedLock = lec.getLock();
        Mockito.when((Object)lec.isReleaseOnCancel()).thenReturn((Object)true);
        ((Lock)Mockito.doAnswer(invocation -> {
            LeaderElectionRecord leaderRecord = (LeaderElectionRecord)invocation.getArgument(1, LeaderElectionRecord.class);
            activeLer.set(leaderRecord);
            signal.countDown();
            return null;
        }).when((Object)mockedLock)).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        LeaderElector leaderElector = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, (Executor)CommonThreadPool.get());
        CompletableFuture started = leaderElector.start();
        Assertions.assertTrue((boolean)signal.await(10L, TimeUnit.SECONDS));
        started.cancel(true);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> Utils.isNullOrEmpty((String)((LeaderElectionRecord)activeLer.get()).getHolderIdentity()));
        Assertions.assertEquals((int)0, (int)activeLer.get().getLeaderTransitions());
        leaderElector = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, (Executor)CommonThreadPool.get());
        Assertions.assertTrue((boolean)leaderElector.tryAcquireOrRenew());
        Assertions.assertEquals((int)1, (int)activeLer.get().getLeaderTransitions());
    }

    @Test
    void shouldStopOnReleaseWhenCanceled() throws Exception {
        AtomicReference<LeaderElectionRecord> activeLer = new AtomicReference<LeaderElectionRecord>();
        LeaderElectionConfig lec = this.mockLeaderElectionConfiguration(activeLer);
        CountDownLatch signal = new CountDownLatch(1);
        Lock mockedLock = lec.getLock();
        Mockito.when((Object)lec.isReleaseOnCancel()).thenReturn((Object)true);
        AtomicInteger count = new AtomicInteger();
        ((Lock)Mockito.doAnswer(invocation -> {
            if (count.addAndGet(1) == 2) {
                throw new KubernetesClientException(((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(409))).build());
            }
            LeaderElectionRecord leaderRecord = (LeaderElectionRecord)invocation.getArgument(1, LeaderElectionRecord.class);
            activeLer.set(leaderRecord);
            signal.countDown();
            return null;
        }).when((Object)mockedLock)).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        LeaderElector leaderElector = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, (Executor)CommonThreadPool.get());
        CompletableFuture started = leaderElector.start();
        Assertions.assertTrue((boolean)signal.await(10L, TimeUnit.SECONDS));
        started.cancel(true);
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStopLeading();
    }

    @Test
    void shouldRelease() throws Exception {
        AtomicReference<LeaderElectionRecord> activeLer = new AtomicReference<LeaderElectionRecord>();
        LeaderElectionConfig lec = this.mockLeaderElectionConfiguration(activeLer);
        CountDownLatch signal = new CountDownLatch(1);
        Lock mockedLock = lec.getLock();
        ((Lock)Mockito.doAnswer(invocation -> {
            LeaderElectionRecord leaderRecord = (LeaderElectionRecord)invocation.getArgument(1, LeaderElectionRecord.class);
            activeLer.set(leaderRecord);
            signal.countDown();
            return null;
        }).when((Object)mockedLock)).update((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        LeaderElector leaderElector = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, (Executor)CommonThreadPool.get());
        CompletableFuture started = leaderElector.start();
        Assertions.assertTrue((boolean)signal.await(10L, TimeUnit.SECONDS));
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStartLeading();
        leaderElector.release();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks())).onStopLeading();
            return true;
        });
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)2))).onStartLeading();
            return true;
        });
        started.cancel(true);
    }

    @Test
    void isLeaderAndIsLeaderShouldReturnTrue() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLock().identity()).thenReturn((Object)"1337");
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getHolderIdentity()).thenReturn((Object)"1337");
        boolean result = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, Runnable::run).isLeader(ler);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void isLeaderTrueEmptyIdentity() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLock().identity()).thenReturn((Object)"1337");
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofMinutes(59L));
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getRenewTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC));
        boolean result = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, Runnable::run).canBecomeLeader(ler);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void isLeaderAndIsNotLeaderShouldReturnFalse() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLock().identity()).thenReturn((Object)"313373");
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getHolderIdentity()).thenReturn((Object)"1337");
        boolean result = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, Runnable::run).isLeader(ler);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void canBecomeLeaderAndDifferentLeaderWithExpiredLockShouldReturnTrue() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class);
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofMinutes(59L));
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getHolderIdentity()).thenReturn((Object)"someone");
        Mockito.when((Object)ler.getRenewTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).minusHours(1L));
        boolean result = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, Runnable::run).canBecomeLeader(ler);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void canBecomeLeaderAndDifferentLeaderWithActiveLockShouldReturnFalse() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class);
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofHours(1L));
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getHolderIdentity()).thenReturn((Object)"someone");
        Mockito.when((Object)ler.getRenewTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC));
        boolean result = new LeaderElector((KubernetesClient)Mockito.mock(NamespacedKubernetesClient.class), lec, Runnable::run).canBecomeLeader(ler);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void loopCompletesOk() throws Exception {
        CompletableFuture cf = LeaderElector.loop(completion -> completion.complete(null), () -> 1L, (Executor)CommonThreadPool.get());
        cf.get(500L, TimeUnit.MILLISECONDS);
    }

    @Test
    void loopCancel() throws Exception {
        AtomicInteger count = new AtomicInteger();
        CompletableFuture cf = LeaderElector.loop(completion -> count.getAndIncrement(), () -> 10L, (Executor)CommonThreadPool.get());
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> count.get() >= 1);
        cf.cancel(true);
        Thread.sleep(100L);
        int sample = count.get();
        Thread.sleep(100L);
        Assertions.assertEquals((int)sample, (int)count.get());
    }

    @Test
    void nowShouldReturnZonedTimeInUTC() {
        Instant now = Instant.now();
        ZonedDateTime result = LeaderElector.now();
        Assertions.assertEquals((Object)ZoneOffset.UTC, (Object)result.getZone());
        long delta = result.toEpochSecond() - now.getEpochSecond();
        Assertions.assertTrue((delta <= 1L ? 1 : 0) != 0);
        Assertions.assertTrue((delta >= 0L ? 1 : 0) != 0);
    }

    @Test
    void jitterWithPositiveShouldReturnPositiveDouble() {
        Duration test = Duration.of(1L, ChronoUnit.SECONDS);
        Duration result = LeaderElector.jitter((Duration)test, (double)1.0);
        Assertions.assertTrue((result.toMillis() < 2000L ? 1 : 0) != 0);
        Assertions.assertTrue((result.toMillis() > 1000L ? 1 : 0) != 0);
    }

    @Test
    void jitterWithNegativeShouldReturnDuration() {
        Duration test = Duration.of(1L, ChronoUnit.SECONDS);
        Duration result = LeaderElector.jitter((Duration)test, (double)-1.0);
        Assertions.assertTrue((result.toMillis() < 2000L ? 1 : 0) != 0);
        Assertions.assertTrue((result.toMillis() > 1000L ? 1 : 0) != 0);
    }

    private LeaderElectionConfig mockLeaderElectionConfiguration() throws Exception {
        return this.mockLeaderElectionConfiguration(new AtomicReference<LeaderElectionRecord>());
    }

    private LeaderElectionConfig mockLeaderElectionConfiguration(AtomicReference<LeaderElectionRecord> activeLer) throws Exception {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofSeconds(2L));
        Mockito.when((Object)lec.getRenewDeadline()).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)lec.getRetryPeriod()).thenReturn((Object)Duration.ofMillis(10L));
        Lock mockedLock = lec.getLock();
        Mockito.when((Object)mockedLock.identity()).thenReturn((Object)"1337");
        Mockito.when((Object)mockedLock.get((KubernetesClient)ArgumentMatchers.any())).thenReturn(null).thenAnswer(invocation -> (LeaderElectionRecord)activeLer.get());
        ((Lock)Mockito.doAnswer(invocation -> {
            LeaderElectionRecord leaderRecord = (LeaderElectionRecord)invocation.getArgument(1, LeaderElectionRecord.class);
            activeLer.set(leaderRecord);
            return null;
        }).when((Object)mockedLock)).create((KubernetesClient)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        return lec;
    }
}

