/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ExponentialBackoffIntervalCalculatorTest {
    ExponentialBackoffIntervalCalculatorTest() {
    }

    @Test
    @DisplayName(value="nextReconnectInterval, from null config, should use default values")
    void nextReconnectIntervalFromNullConfig() {
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from(null);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(100L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(200L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(400L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(800L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(1600L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(3200L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(3200L);
    }

    @Test
    @DisplayName(value="nextReconnectInterval, from config, should use Config-provided values")
    void nextReconnectIntervalFromConfig() {
        RequestConfig requestConfig = ((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffInterval(1)).build();
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from((RequestConfig)requestConfig);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(1L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(2L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(4L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(8L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(16L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(32L);
        Assertions.assertThat((long)calculator.nextReconnectInterval()).isEqualTo(32L);
    }

    @Test
    @DisplayName(value="shouldRetry, from null config within limit, should use default values returns true")
    void shouldRetryFromNullConfigReturnsFalse() {
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from(null);
        IntStream.range(0, 9).forEach(i -> calculator.nextReconnectInterval());
        Assertions.assertThat((boolean)calculator.shouldRetry()).isTrue();
    }

    @Test
    @DisplayName(value="shouldRetry, from null config outside limit, should use default values returns false")
    void shouldRetryFromNullConfigReturnsTrue() {
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from(null);
        IntStream.range(0, 10).forEach(i -> calculator.nextReconnectInterval());
        Assertions.assertThat((boolean)calculator.shouldRetry()).isFalse();
    }

    @Test
    @DisplayName(value="shouldRetry, from config within limit, returns true")
    void shouldRetryFromConfigReturnsTrue() {
        RequestConfig requestConfig = ((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(5)).build();
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from((RequestConfig)requestConfig);
        IntStream.range(0, 4).forEach(i -> calculator.nextReconnectInterval());
        Assertions.assertThat((boolean)calculator.shouldRetry()).isTrue();
    }

    @Test
    @DisplayName(value="shouldRetry, from config outside limit, returns false")
    void shouldRetryFromConfigReturnsFalse() {
        RequestConfig requestConfig = ((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(5)).build();
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from((RequestConfig)requestConfig);
        IntStream.range(0, 5).forEach(i -> calculator.nextReconnectInterval());
        Assertions.assertThat((boolean)calculator.shouldRetry()).isFalse();
    }

    @Test
    @DisplayName(value="resetReconnectAttempts, from config outside limit, allows for more retries")
    void resetReconnectAttemptsFromConfigAllowsForMoreRetries() {
        RequestConfig requestConfig = ((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(5)).build();
        ExponentialBackoffIntervalCalculator calculator = ExponentialBackoffIntervalCalculator.from((RequestConfig)requestConfig);
        IntStream.range(0, 5).forEach(i -> calculator.nextReconnectInterval());
        calculator.resetReconnectAttempts();
        ((ObjectAssert)Assertions.assertThat((Object)calculator).returns((Object)0, ExponentialBackoffIntervalCalculator::getCurrentReconnectAttempt)).returns((Object)true, ExponentialBackoffIntervalCalculator::shouldRetry);
    }
}

