/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterBuilder;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class OpenIDConnectionUtilsBehaviorTest {
    @TempDir
    Path tempDir;
    private TestStandardHttpClientFactory httpClientFactory;
    private TestStandardHttpClientBuilder httpClientBuilder;
    private PrintStream originalSystemErrStream;
    private ByteArrayOutputStream systemErr;
    private Config originalConfig;
    private Map<String, String> authProviderConfig;

    OpenIDConnectionUtilsBehaviorTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.httpClientFactory = new TestStandardHttpClientFactory(TestStandardHttpClientFactory.Mode.SINGLETON);
        this.httpClientBuilder = this.httpClientFactory.newBuilder();
        this.originalSystemErrStream = System.err;
        this.systemErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(this.systemErr));
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        X509CertificateHolder cert = new JcaX509v3CertificateBuilder(new X500Name("o=Fabric8"), BigInteger.ONE, new Date(), new Date(new Date().getTime() + 1000L), new X500Name("cn=auth.fabric8.example.com"), keyPair.getPublic()).build(new JcaContentSignerBuilder("SHA256WithRSA").build(keyPair.getPrivate()));
        Path validCert = this.tempDir.resolve("valid.crt");
        Files.write(validCert, Base64.getEncoder().encode(cert.getEncoded()), new OpenOption[0]);
        Path kubeConfigFile = this.tempDir.resolve("kube-config");
        io.fabric8.kubernetes.api.model.Config kubeConfig = ((io.fabric8.kubernetes.api.model.ConfigBuilder)((io.fabric8.kubernetes.api.model.ConfigBuilder)((io.fabric8.kubernetes.api.model.ConfigBuilder)((io.fabric8.kubernetes.api.model.ConfigBuilder)new io.fabric8.kubernetes.api.model.ConfigBuilder().addToClusters(new NamedCluster[]{((NamedClusterBuilder)((NamedClusterFluent.ClusterNested)((NamedClusterFluent.ClusterNested)((NamedClusterBuilder)new NamedClusterBuilder().withName("default-cluster")).withNewCluster().withServer("https://cluster.example.com")).withCertificateAuthority(validCert.toFile().getAbsolutePath())).endCluster()).build()})).addToUsers(new NamedAuthInfo[]{((NamedAuthInfoBuilder)((NamedAuthInfoFluent.UserNested)((NamedAuthInfoBuilder)new NamedAuthInfoBuilder().withName("default-user")).withNewUser().withAuthProvider(new AuthProviderConfig())).endUser()).build()})).addToContexts(new NamedContext[]{((NamedContextBuilder)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextBuilder)new NamedContextBuilder().withName("default")).withNewContext().withCluster("default-cluster")).withUser("default-user")).endContext()).build()})).withCurrentContext("default")).build();
        Files.write(kubeConfigFile, Serialization.asYaml((Object)kubeConfig).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.originalConfig = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withFile(this.tempDir.resolve("kube-config").toFile())).build().refresh();
        this.authProviderConfig = new HashMap<String, String>();
        this.authProviderConfig.put("id-token", "original-token");
        this.authProviderConfig.put("idp-issuer-url", "https://auth.fabric8.example.com");
        this.authProviderConfig.put("client-id", "id-of-test-client");
        this.authProviderConfig.put("client-secret", "secret-of-test-client");
    }

    @AfterEach
    void tearDown() {
        System.setErr(this.originalSystemErrStream);
    }

    @Test
    @DisplayName(value="Unsupported token refresh, resolves token from auth provider config")
    void withUnsupportedTokenRefresh() throws Exception {
        String result = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)this.originalConfig, this.authProviderConfig, (HttpClient.Builder)this.httpClientBuilder).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)result).isEqualTo("original-token");
    }

    @Nested
    @DisplayName(value="With support for token refresh")
    class WithRefreshToken {
        WithRefreshToken() {
        }

        @BeforeEach
        void setUp() {
            OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig.put("refresh-token", "original-refresh-token");
        }

        @Test
        @DisplayName(value="With invalid cert data in original config, throws certificate exception")
        void withInvalidCertDataInConfig() {
            OpenIDConnectionUtilsBehaviorTest.this.originalConfig = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(OpenIDConnectionUtilsBehaviorTest.this.originalConfig).withCaCertData(Base64.getEncoder().encodeToString(new byte[]{48, -17, -65, -67, 3, 6}))).withCaCertFile(null)).build();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder)).isInstanceOf(RuntimeException.class)).hasMessage("Could not import idp certificate").cause().isInstanceOf(CertificateException.class);
        }

        @Test
        @DisplayName(value="With invalid cert data in provided auth config, throws certificate exception")
        void withInvalidCertDataInAuthProviderConfig() {
            OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig.put("idp-certificate-authority-data", Base64.getEncoder().encodeToString(new byte[]{48, -17, -65, -67, 3, 6}));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder)).isInstanceOf(RuntimeException.class)).hasMessage("Could not import idp certificate").cause().isInstanceOf(CertificateException.class);
        }

        @Test
        @DisplayName(value="With invalid cert file in original config, throws certificate exception")
        void withInvalidCertFileInConfig() throws IOException {
            Path invalidCert = OpenIDConnectionUtilsBehaviorTest.this.tempDir.resolve("invalid.crt");
            Files.write(invalidCert, new byte[]{48, -17, -65, -67, 3, 6}, new OpenOption[0]);
            OpenIDConnectionUtilsBehaviorTest.this.originalConfig = ((ConfigBuilder)new ConfigBuilder(OpenIDConnectionUtilsBehaviorTest.this.originalConfig).withCaCertFile(invalidCert.toFile().getAbsolutePath())).build();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder)).isInstanceOf(RuntimeException.class)).hasMessage("Could not import idp certificate").cause().isInstanceOf(CertificateException.class);
        }

        @Test
        @DisplayName(value="With missing cert file in original config, throws NPE")
        void withMissingCertFileInConfig() {
            Path missingCert = OpenIDConnectionUtilsBehaviorTest.this.tempDir.resolve("missing.crt");
            OpenIDConnectionUtilsBehaviorTest.this.originalConfig = ((ConfigBuilder)new ConfigBuilder(OpenIDConnectionUtilsBehaviorTest.this.originalConfig).withCaCertFile(missingCert.toFile().getAbsolutePath())).build();
            Assertions.assertThatThrownBy(() -> OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder)).isInstanceOf(NullPointerException.class);
        }

        @Nested
        @DisplayName(value="With valid OpenID Connect Discovery")
        class WithValidOpenIDConnectDiscovery {
            WithValidOpenIDConnectDiscovery() {
            }

            @BeforeEach
            void setUp() {
                OpenIDConnectionUtilsBehaviorTest.this.httpClientFactory.expect("/.well-known/openid-configuration", 200, "{\"issuer\": \"https://auth.example.com\",\"token_endpoint\": \"https://auth.example.com/token\",\"response_types_supported\": [\"code\",\"id_token\"]}");
            }

            @Test
            @DisplayName(value="With valid token repsonse and missing kube config, logs warning")
            void withValidTokenResponseAndMissingKubeConfig() throws Exception {
                Files.delete(OpenIDConnectionUtilsBehaviorTest.this.originalConfig.getFile().toPath());
                OpenIDConnectionUtilsBehaviorTest.this.httpClientFactory.expect("/token", 200, "{\"id_token\": \"new-token\"}");
                String result = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder).get(10L, TimeUnit.SECONDS);
                Assertions.assertThat((String)result).isEqualTo("new-token");
                Assertions.assertThat((String)OpenIDConnectionUtilsBehaviorTest.this.systemErr.toString()).contains(new CharSequence[]{"oidc: failure while persisting new tokens into KUBECONFIG"});
            }

            @Nested
            @DisplayName(value="With valid token response")
            class WithValidTokenResponse {
                private String result;

                WithValidTokenResponse() {
                }

                @BeforeEach
                void setUp() throws Exception {
                    OpenIDConnectionUtilsBehaviorTest.this.httpClientFactory.expect("/token", 200, "{\"id_token\": \"new-token\",\"refresh_token\": \"new-refresh-token\"}");
                    this.result = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder).get(10L, TimeUnit.SECONDS);
                }

                @Test
                @DisplayName(value="Resolves token from token endpoint")
                void resolvesTokenFromTokenEndpoint() {
                    Assertions.assertThat((String)this.result).isEqualTo("new-token");
                }

                @Test
                @DisplayName(value="Updates current config auth provider config with new token")
                void updatesCurrentConfigAuthProviderConfigWithNewToken() {
                    ((MapAssert)((MapAssert)Assertions.assertThat((Object)OpenIDConnectionUtilsBehaviorTest.this.originalConfig).extracting(Config::getAuthProvider).extracting(AuthProviderConfig::getConfig).asInstanceOf(InstanceOfAssertFactories.map(String.class, String.class))).containsEntry((Object)"id-token", (Object)"new-token")).containsEntry((Object)"refresh-token", (Object)"new-refresh-token");
                }

                @Test
                @DisplayName(value="Updates current config auth provider config with new token in file")
                void updatesCurrentConfigAuthProviderConfigWithNewTokenInFile() throws Exception {
                    ((MapAssert)((MapAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((Object)Serialization.unmarshal((String)new String(Files.readAllBytes(OpenIDConnectionUtilsBehaviorTest.this.originalConfig.getFile().toPath()), StandardCharsets.UTF_8), io.fabric8.kubernetes.api.model.Config.class)).extracting(io.fabric8.kubernetes.api.model.Config::getUsers).asInstanceOf(InstanceOfAssertFactories.list(NamedAuthInfo.class))).singleElement()).extracting("user.authProvider.config").asInstanceOf(InstanceOfAssertFactories.map(String.class, String.class))).containsEntry((Object)"id-token", (Object)"new-token")).containsEntry((Object)"refresh-token", (Object)"new-refresh-token");
                }

                @Test
                @DisplayName(value="Certificate is loaded into HttpClient trust manager")
                void certificateIsLoadedIntoHttpClientTrustManager() {
                    ((ObjectArrayAssert)((ObjectAssert)Assertions.assertThat((Object[])OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder.getTrustManagers()).singleElement().asInstanceOf(InstanceOfAssertFactories.type(X509ExtendedTrustManager.class))).extracting(X509TrustManager::getAcceptedIssuers).asInstanceOf(InstanceOfAssertFactories.array(X509Certificate[].class))).extracting(X509Certificate::getSubjectDN).extracting(Principal::getName).contains((Object[])new String[]{"CN=auth.fabric8.example.com"});
                }

                @Test
                @DisplayName(value="Token refresh request contains valid auth and form data")
                void tokenRefreshRequestContainsValidFormData() {
                    ((ObjectAssert)((ListAssert)Assertions.assertThat(OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder.build().getRecordedConsumeBytesDirects()).filteredOn(r -> r.getRequest().uri().getPath().equals("/token"))).singleElement()).extracting(TestStandardHttpClient.RecordedConsumeBytesDirect::getRequest).hasFieldOrPropertyWithValue("method", (Object)"POST").hasFieldOrPropertyWithValue("contentType", (Object)"application/x-www-form-urlencoded").hasFieldOrPropertyWithValue("bodyString", (Object)"refresh_token=original-refresh-token&grant_type=refresh_token&client_id=id-of-test-client&client_secret=secret-of-test-client").returns((Object)"Basic aWQtb2YtdGVzdC1jbGllbnQ6c2VjcmV0LW9mLXRlc3QtY2xpZW50", r -> r.header("Authorization"));
                }
            }

            @Nested
            @DisplayName(value="With invalid token response body")
            class WithInvalidTokenResponseBody {
                private String result;

                WithInvalidTokenResponseBody() {
                }

                @BeforeEach
                void setUp() throws Exception {
                    OpenIDConnectionUtilsBehaviorTest.this.httpClientFactory.expect("/token", 200, "Not JSON");
                    this.result = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder).get(10L, TimeUnit.SECONDS);
                }

                @Test
                @DisplayName(value="Resolves token from auth provider config (fallback)")
                void fallbacksToOriginalToken() {
                    Assertions.assertThat((String)this.result).isEqualTo("original-token");
                }

                @Test
                @DisplayName(value="Logs JSON parsing error")
                void logsJsonParsingError() {
                    ((AbstractStringAssert)Assertions.assertThat((String)OpenIDConnectionUtilsBehaviorTest.this.systemErr.toString()).contains(new CharSequence[]{"Failure in fetching refresh token:"})).contains(new CharSequence[]{"Cannot construct instance of `java.util.LinkedHashMap`"});
                }

                @Test
                @DisplayName(value="Logs token fallback warning")
                void logsTokenFallbackWarning() {
                    Assertions.assertThat((String)OpenIDConnectionUtilsBehaviorTest.this.systemErr.toString()).contains(new CharSequence[]{"token response did not contain an id_token, either the scope \\\"openid\\\" wasn't requested upon login, or the provider doesn't support id_tokens as part of the refresh response."});
                }
            }

            @Nested
            @DisplayName(value="With 404 token response")
            class WithNotFoundTokenResponse {
                private String result;

                WithNotFoundTokenResponse() {
                }

                @BeforeEach
                void setUp() throws Exception {
                    OpenIDConnectionUtilsBehaviorTest.this.httpClientFactory.expect("/token", 404, "Not Found /token");
                    this.result = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder).get(10L, TimeUnit.SECONDS);
                }

                @Test
                @DisplayName(value="Resolves token from auth provider config (fallback)")
                void fallbacksToOriginalToken() {
                    Assertions.assertThat((String)this.result).isEqualTo("original-token");
                }

                @Test
                @DisplayName(value="Logs refresh token response")
                void logsRefreshTokenResponse() {
                    Assertions.assertThat((String)OpenIDConnectionUtilsBehaviorTest.this.systemErr.toString()).contains(new CharSequence[]{"Response: Not Found /token"});
                }

                @Test
                @DisplayName(value="Logs token fallback warning")
                void logsTokenFallbackWarning() {
                    Assertions.assertThat((String)OpenIDConnectionUtilsBehaviorTest.this.systemErr.toString()).contains(new CharSequence[]{"token response did not contain an id_token, either the scope \\\"openid\\\" wasn't requested upon login, or the provider doesn't support id_tokens as part of the refresh response."});
                }
            }
        }

        @Nested
        @DisplayName(value="With 404 OpenID Connect Discovery response")
        @Disabled(value="This scenario is not implemented")
        class WithNotFoundOpenIDConnectDiscovery {
            WithNotFoundOpenIDConnectDiscovery() {
            }

            @BeforeEach
            void setUp() {
                OpenIDConnectionUtilsBehaviorTest.this.httpClientFactory.expect("/.well-known/openid-configuration", 404, "Not Found /.well-known/openid-configuration");
            }

            @Test
            @DisplayName(value="Resolves token from auth provider config (fallback)")
            void fallbacksToOriginalToken() throws Exception {
                String result = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)OpenIDConnectionUtilsBehaviorTest.this.originalConfig, (Map)OpenIDConnectionUtilsBehaviorTest.this.authProviderConfig, (HttpClient.Builder)OpenIDConnectionUtilsBehaviorTest.this.httpClientBuilder).get(10L, TimeUnit.SECONDS);
                Assertions.assertThat((String)result).isEqualTo("original-token");
            }
        }
    }
}

