/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.fabric8.kubernetes.api.model.AnyType;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.fabric8.kubernetes.model.jackson.JsonUnwrappedDeserializer;
import io.fabric8.kubernetes.model.jackson.UnwrappedTypeResolverBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SerializationTest {
    SerializationTest() {
    }

    @Test
    void testNullSerialization() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"---\nfield: null\n", (Object)Serialization.asYaml((Object)new WithNull()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"field\":null}", (Object)Serialization.asJson((Object)new WithNull()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"--- {}\n", (Object)Serialization.asYaml((Object)new WithoutNull()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)Serialization.asJson((Object)new WithoutNull()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"key\":null}", (Object)Serialization.asJson(map));
    }

    @Test
    void unmarshalCRDWithSchema() throws Exception {
        String input = this.readYamlToString("/serialization/test-crd-schema.yml");
        CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)input, CustomResourceDefinition.class);
        JSONSchemaProps spec = (JSONSchemaProps)crd.getSpec().getValidation().getOpenAPIV3Schema().getProperties().get("spec");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)spec).hasFieldOrPropertyWithValue("properties.builderName.example", (Object)new TextNode("builder-example"))).hasFieldOrPropertyWithValue("properties.hollow.default", (Object)BooleanNode.FALSE)).hasFieldOrPropertyWithValue("properties.dimensions.properties.x.default", (Object)new IntNode(10))).extracting(JSONSchemaProps::getRequired).asList().containsExactly(new Object[]{"builderName", "edges", "dimensions"});
    }

    @Test
    void asYamlWithDeserializedCRD() throws Exception {
        String input = this.readYamlToString("/serialization/test-crd-schema.yml");
        CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)input, CustomResourceDefinition.class);
        String result = Serialization.asYaml((Object)crd);
        Assertions.assertThat((String)result.trim()).isEqualTo(input.trim());
    }

    @Test
    @DisplayName(value="unmarshal, String containing List with windows like line-ends (CRLF), all list items should be available")
    void unmarshalListWithWindowsLineSeparatorsString() throws Exception {
        String crlfFile = this.readYamlToString("/serialization/test-list.yml");
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)crlfFile, KubernetesResource.class);
        ((AbstractListAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Object)result).asInstanceOf(InstanceOfAssertFactories.type(KubernetesList.class))).extracting(DefaultKubernetesResourceList::getItems).asList().hasSize(2)).hasAtLeastOneElementOfType(Service.class)).hasAtLeastOneElementOfType(Deployment.class);
    }

    private String readYamlToString(String path) throws IOException {
        return Files.readAllLines(new File(SerializationTest.class.getResource(path).getFile()).toPath(), StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("#")).collect(Collectors.joining("\n"));
    }

    @Test
    void testSerializeYamlWithAlias() {
        InputStream fileInputStream = this.getClass().getResourceAsStream("/serialization/test-pod-manifest-with-aliases.yml");
        Pod pod = (Pod)Serialization.unmarshal((InputStream)fileInputStream);
        ((AbstractListAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pod).isNotNull()).hasFieldOrPropertyWithValue("metadata.name", (Object)"test-pod-with-alias")).hasFieldOrPropertyWithValue("spec.nodeSelector.workload", (Object)"build")).hasFieldOrPropertyWithValue("spec.securityContext.runAsGroup", (Object)1000L)).hasFieldOrPropertyWithValue("spec.securityContext.runAsUser", (Object)1000L)).extracting(Pod::getSpec).returns(Collections.singletonList(new Toleration("NoSchedule", "nodeType", "Equal", null, "build")), PodSpec::getTolerations).extracting(PodSpec::getContainers).asList().hasSize(2)).extracting(new String[]{"name", "image", "resources.requests.cpu"}).containsExactly((Object[])new Tuple[]{new Tuple(new Object[]{"ubuntu", "ubuntu:bionic", new Quantity("100m")}), new Tuple(new Object[]{"python3", "python:3.7", new Quantity("100m")})});
    }

    @Test
    void cloneKubernetesResourceReturnsDifferentInstance() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod")).endMetadata()).build();
        Pod clonePod = (Pod)Serialization.clone((Object)pod);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)clonePod).isEqualTo((Object)pod)).isNotSameAs((Object)pod)).hasFieldOrPropertyWithValue("metadata.name", (Object)"pod");
    }

    @Test
    void cloneNonResourceReturnsDifferentInstance() {
        Map<String, String> value = Collections.singletonMap("key", "value");
        Map cloneValue = (Map)Serialization.clone(value);
        ((MapAssert)Assertions.assertThat((Map)cloneValue).isEqualTo(value)).isNotSameAs(value);
    }

    @Test
    @DisplayName(value="unmarshal, with valid YAML custom resource, should return GenericKubernetesResource instance")
    void unmarshalWithValidCustomResourceShouldReturnGenericCustomResource() {
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((InputStream)SerializationTest.class.getResourceAsStream("/serialization/custom-resource.yml"));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotNull()).isInstanceOf(GenericKubernetesResource.class)).hasFieldOrPropertyWithValue("apiVersion", (Object)"the-cr.example.com/v1")).hasFieldOrPropertyWithValue("Kind", (Object)"SomeCustomResource")).hasFieldOrPropertyWithValue("metadata.name", (Object)"custom-resource-example")).hasFieldOrPropertyWithValue("additionalProperties.spec.field", (Object)"value")).hasFieldOrPropertyWithValue("additionalProperties.status.reconciled", (Object)true);
    }

    @Test
    void unmarshalWithInvalidYamlShouldReturnRawExtension() {
        InputStream is = SerializationTest.class.getResourceAsStream("/serialization/invalid-yaml.yml");
        RawExtension result = (RawExtension)Serialization.unmarshal((InputStream)is);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"This\nis not\nYAML", (Object)result.getValue());
    }

    @Test
    void unmarshalYamlArrayShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Serialization.unmarshal((String)"- 1\n- 2")).withMessageStartingWith("Cannot parse a nested array containing non-object resource");
    }

    @Test
    void unmarshalJsonArrayShouldThrowException() {
        Assertions.assertThatExceptionOfType(KubernetesClientException.class).isThrownBy(() -> Serialization.unmarshal((String)"[1, 2]")).withMessage("An error has occurred.").havingCause().withMessageStartingWith("Cannot parse a nested array containing non-object resource");
    }

    @Test
    void unmarshalYamlArrayWithProvidedTypeShouldDeserialize() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(1, 2), (Object)Serialization.unmarshal((String)"- 1\n- 2", List.class));
    }

    @Test
    void unmarshalJsonArrayWithProvidedTypeShouldDeserialize() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(1, 2), (Object)Serialization.unmarshal((String)"[1, 2]", List.class));
    }

    @ParameterizedTest(name="''{0}'' should be deserialized as ''{1}''")
    @MethodSource(value={"unmarshalPrimitivesInput"})
    void unmarshalPrimitives(String input, Object expected) {
        Assertions.assertThat((Object)Serialization.unmarshal((String)input)).extracting(AnyType::getValue).isEqualTo(expected);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)Serialization.unmarshal((String)"\"a\"", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)Serialization.unmarshal((String)"a", String.class));
    }

    @ParameterizedTest(name="''{0}'' and ''{2}'' target type should be deserialized as ''{1}''")
    @MethodSource(value={"unmarshalPrimitivesInput"})
    void unmarshalPrimitivesWithType(String input, Object expected, Class<?> targetType) {
        Assertions.assertThat((Object)Serialization.unmarshal((String)input, targetType)).isEqualTo(expected);
    }

    static Stream<Arguments> unmarshalPrimitivesInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"\"a\"", "a", String.class}), Arguments.arguments((Object[])new Object[]{"a", "a", String.class}), Arguments.arguments((Object[])new Object[]{"1", 1, Integer.class}), Arguments.arguments((Object[])new Object[]{"true", true, Boolean.class}), Arguments.arguments((Object[])new Object[]{"1.2", 1.2, Double.class}));
    }

    @Test
    void unmarshalRawResource() {
        InputStream is = SerializationTest.class.getResourceAsStream("/serialization/invalid-resource.yml");
        RawExtension raw = (RawExtension)Serialization.unmarshal((InputStream)is);
        ((Map)raw.getValue()).get("not-a").equals("resource");
    }

    @Test
    @DisplayName(value="unmarshal, with valid YAML list, should return KubernetesList")
    void unmarshalWithValidListShouldReturnKubernetesList() {
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((InputStream)SerializationTest.class.getResourceAsStream("/serialization/kubernetes-list.yml"));
        ((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Object)result).asInstanceOf(InstanceOfAssertFactories.type(KubernetesList.class))).extracting(DefaultKubernetesResourceList::getItems).asList().hasSize(3)).extracting(new String[]{"class", "apiVersion", "kind", "metadata.name"}).containsExactlyInAnyOrder((Object[])new Tuple[]{new Tuple(new Object[]{GenericKubernetesResource.class, "custom.resource.example.com/v1", "Example", "a-custom-resource"}), new Tuple(new Object[]{Namespace.class, "v1", "Namespace", "a-namespace"}), new Tuple(new Object[]{Pod.class, "v1", "Pod", "a-pod"})});
    }

    @Test
    void testSerializeYamlWithJsonSubTypes() {
        Root root = new Root();
        root.setTypeable(new Typed());
        String result = Serialization.asYaml((Object)root);
        Assertions.assertThat((String)result).isEqualTo("---\ntypeable:\n  type: \"x\"\n", new Object[]{Serialization.asYaml((Object)root)});
    }

    @Test
    void nullValueShouldNotBeOutput() {
        MyCR cr = new MyCR();
        String s = Serialization.asYaml((Object)((Object)cr));
        ((AbstractStringAssert)Assertions.assertThat((String)s).doesNotContain(new CharSequence[]{"status"})).contains(new CharSequence[]{"spec: \"foo\""});
    }

    @Test
    void quantityQuoting() {
        Quantity quantity = (Quantity)Serialization.unmarshal((String)"amount: \"2\"\nformat: \"Gi\"", Quantity.class);
        Assertions.assertThat((String)Serialization.asYaml((Object)quantity)).isEqualTo("--- \"2Gi\"\n");
    }

    @Test
    void parseConfigWithRaw() {
        Config config = (Config)Serialization.unmarshal((String)"extensions: \n- name: foo\n  extension:\n    not: kubernetesresource", Config.class);
        Assertions.assertThat((String)Serialization.asYaml((Object)config)).isEqualTo("---\nextensions:\n- extension:\n    not: \"kubernetesresource\"\n  name: \"foo\"\n");
    }

    @Test
    void polymorphicUnwrap() {
        PolyParent parent = (PolyParent)Serialization.unmarshal((String)"other: 1\nname: x", PolyParent.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x", (Object)((Named)parent.poly).name);
        parent = (PolyParent)Serialization.unmarshal((String)"other: 1", PolyParent.class);
        Assertions.assertThat((Object)parent.poly).isNull();
    }

    @Test
    void unmarshal_podWithYYYYMMDDAnnotation_shouldNotConvertToDate() {
        InputStream inputStream = this.getClass().getResourceAsStream("/serialization/test-pod-manifest-dateformat-annotation.yml");
        Pod pod = (Pod)Serialization.unmarshal((InputStream)inputStream);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pod).isNotNull()).hasFieldOrPropertyWithValue("spec.shareProcessNamespace", (Object)false)).hasFieldOrPropertyWithValue("spec.terminationGracePeriodSeconds", (Object)2L)).extracting(Pod::getMetadata).extracting(ObjectMeta::getAnnotations).isEqualTo(Collections.singletonMap("report_date", "2020-01-01"));
    }

    @Test
    void unmarshal_leaseWithTypedValues_ShouldConvertToTypedFields() {
        InputStream inputStream = this.getClass().getResourceAsStream("/serialization/test-lease-manifest-typed-fields.yml");
        Lease lease = (Lease)Serialization.unmarshal((InputStream)inputStream);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)lease).isNotNull()).hasFieldOrPropertyWithValue("metadata.annotations", Collections.singletonMap("creationTimestamp", "2022-07-22T10:42:02Z"))).hasFieldOrPropertyWithValue("spec.leaseDurationSeconds", (Object)2)).hasFieldOrPropertyWithValue("spec.leaseTransitions", (Object)3)).extracting(Lease::getSpec).extracting(LeaseSpec::getAcquireTime).isInstanceOf(ZonedDateTime.class);
    }

    @Test
    void unmarshal_configMapWithBoolAndDateData_shouldBeDeserializedAsString() {
        InputStream inputStream = this.getClass().getResourceAsStream("/serialization/test-configmap-manifest-bool-dateformat.yml");
        ConfigMap configMap = (ConfigMap)Serialization.unmarshal((InputStream)inputStream);
        ((MapAssert)((MapAssert)((ObjectAssert)Assertions.assertThat((Object)configMap).isNotNull()).extracting(ConfigMap::getData).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)"bool", (Object)"NO")).containsEntry((Object)"date", (Object)"2022-07-22");
    }

    @Test
    void testArrayAsYaml() {
        String[] value = new String[]{"x", "y"};
        String yaml = Serialization.asYaml((Object)value);
        Assertions.assertThat((String)yaml).isEqualTo("---\n- \"x\"\n- \"y\"\n");
    }

    @Test
    void testAnyTypeSerialization() {
        AnyType value = new AnyType((Object)"x");
        String yaml = Serialization.asYaml((Object)value);
        Assertions.assertThat((String)yaml).isEqualTo("--- \"x\"\n");
    }

    @Test
    void testAnyTypeDeserialization() {
        String yaml = "x: 1";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", 1);
        AnyType type = (AnyType)Serialization.unmarshal((String)yaml, AnyType.class);
        Assertions.assertThat((Object)type.getValue()).isEqualTo(map);
    }

    @JsonDeserialize(using=JsonUnwrappedDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class PolyParent {
        @JsonUnwrapped
        public Poly poly;
        public int other;

        PolyParent() {
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    static class Counted
    implements Poly {
        public int count;

        Counted() {
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class Named
    implements Poly {
        public String name;

        Named() {
        }
    }

    @JsonTypeResolver(value=UnwrappedTypeResolverBuilder.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Named.class), @JsonSubTypes.Type(value=Counted.class)})
    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION)
    static interface Poly {
    }

    @Group(value="serialization.fabric8.io")
    @Version(value="v1")
    private static class MyCR
    extends CustomResource<String, Void> {
        public MyCR() {
            this.setSpec("foo");
        }
    }

    public static class Root {
        private Typeable typeable;

        public Typeable getTypeable() {
            return this.typeable;
        }

        public void setTypeable(Typeable typeable) {
            this.typeable = typeable;
        }
    }

    public static class Typed
    implements Typeable {
        @Override
        public String getType() {
            return "x";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Typed.class, name="x")})
    public static interface Typeable {
        public String getType();
    }

    static class WithoutNull {
        public Integer field;

        WithoutNull() {
        }
    }

    static class WithNull {
        @JsonInclude
        public Integer field;

        WithNull() {
        }
    }
}

