/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.IpAddressMatcher;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class IpAddressMatcherTest {
    IpAddressMatcherTest() {
    }

    @DisplayName(value="matches returns true for matching IPs and IP/Netmask subnets")
    @ParameterizedTest(name="{index}: IP ''{1}'' matches ''{0}'' IP/Netmask")
    @MethodSource(value={"matchesTrueInput"})
    void matchesTrue(String ipOrSubnet, String ip) {
        Assertions.assertThat((boolean)new IpAddressMatcher(ipOrSubnet).matches(ip)).isTrue();
    }

    static Stream<Arguments> matchesTrueInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"192.168.1.0/24", "192.168.1.104"}), Arguments.arguments((Object[])new Object[]{"192.168.10.110", "192.168.10.110"}), Arguments.arguments((Object[])new Object[]{"192.168.1.0/8", "192.168.10.110"}), Arguments.arguments((Object[])new Object[]{"192.168.1.0/24", "192.168.1.100"}), Arguments.arguments((Object[])new Object[]{"0.0.0.0/0", "123.4.5.6"}), Arguments.arguments((Object[])new Object[]{"0.0.0.0/0", "192.168.0.159"}), Arguments.arguments((Object[])new Object[]{"192.168.0.159/0", "123.4.5.6"}), Arguments.arguments((Object[])new Object[]{"192.168.0.159/0", "192.168.0.159"}));
    }

    @DisplayName(value="matches returns false for non-matching IPs and IP/Netmask subnets")
    @ParameterizedTest(name="{index}: IP ''{1}'' does not match ''{0}'' IP/Netmask")
    @MethodSource(value={"matchesFalseInput"})
    void matchesFalse(String ipOrSubnet, String ip) {
        Assertions.assertThat((boolean)new IpAddressMatcher(ipOrSubnet).matches(ip)).isFalse();
    }

    static Stream<Arguments> matchesFalseInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"192.168.10.110", "192.168.1.0/8"}), Arguments.arguments((Object[])new Object[]{"192.168.1.0/24", "193.168.1.10"}), Arguments.arguments((Object[])new Object[]{"192.168.1.0/24", "192.168.2.10"}), Arguments.arguments((Object[])new Object[]{"192.168.1.0/8", "193.168.1.10"}), Arguments.arguments((Object[])new Object[]{"192.168.1.128/25", "192.168.1.104"}), Arguments.arguments((Object[])new Object[]{"kubernetes.default.svc", "kubernetes.default.svc"}));
    }
}

