/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.BasicItemStore;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class BasicItemStoreTest {
    BasicItemStoreTest() {
    }

    @Test
    void testEmptyStore() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).withResourceVersion("1")).endMetadata()).build();
        BasicItemStore itemStore = new BasicItemStore(BasicItemStoreTest::podToKey);
        Assertions.assertThat((int)itemStore.size()).isZero();
        Assertions.assertThat((Stream)itemStore.keySet()).isEmpty();
        Assertions.assertThat((Stream)itemStore.values()).isEmpty();
        Assertions.assertThat((String)itemStore.getKey((Object)pod)).isEqualTo("pods/test-pod/1");
        Assertions.assertThat((Object)itemStore.get("pods/test-pod/1")).isNull();
        Assertions.assertThat((Object)itemStore.remove("pods/test-pod/1")).isNull();
        Assertions.assertThat((int)itemStore.size()).isZero();
    }

    @Test
    void testPopulateStore() {
        Pod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).withResourceVersion("1")).endMetadata()).build();
        Pod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).withResourceVersion("2")).endMetadata()).build();
        BasicItemStore itemStore = new BasicItemStore(BasicItemStoreTest::podToKey);
        itemStore.put("pods/test-pod/1", (Object)pod1);
        Assertions.assertThat((int)itemStore.size()).isOne();
        ((ListAssert)Assertions.assertThat((Stream)itemStore.keySet()).hasSize(1)).containsExactly((Object[])new String[]{"pods/test-pod/1"});
        ((ListAssert)Assertions.assertThat((Stream)itemStore.values()).hasSize(1)).containsExactly((Object[])new Pod[]{pod1});
        ((ObjectAssert)Assertions.assertThat((Object)itemStore.get("pods/test-pod/1")).isNotNull()).isEqualTo((Object)pod1);
        Assertions.assertThat((Object)itemStore.put(itemStore.getKey((Object)pod2), (Object)pod2)).isNull();
        Assertions.assertThat((int)itemStore.size()).isEqualTo(2);
        Assertions.assertThat((Object)itemStore.remove("pods/test-pod/1")).isEqualTo((Object)pod1);
        Assertions.assertThat((Object)itemStore.get("pods/test-pod/1")).isNull();
        Assertions.assertThat((int)itemStore.size()).isOne();
        Assertions.assertThat((Object)itemStore.remove("pods/test-pod/2")).isEqualTo((Object)pod2);
        Assertions.assertThat((Object)itemStore.get("pods/test-pod/2")).isNull();
        Assertions.assertThat((int)itemStore.size()).isZero();
    }

    @Test
    void parallelStore() throws InterruptedException {
        BasicItemStore itemStore = new BasicItemStore(BasicItemStoreTest::podToKey);
        int tasks = 1000;
        CountDownLatch latch = new CountDownLatch(tasks);
        IntStream.range(0, tasks).mapToObj(arg_0 -> BasicItemStoreTest.lambda$parallelStore$1((ItemStore)itemStore, latch, arg_0)).forEach(ForkJoinPool.commonPool()::execute);
        Assertions.assertThat((boolean)latch.await(15L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((int)itemStore.size()).isEqualTo(tasks);
        ((ListAssert)Assertions.assertThat((Stream)itemStore.keySet()).hasSize(tasks)).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.range(0, tasks).mapToObj(i -> "pods/test-pod/" + i).collect(Collectors.toList()));
        Assertions.assertThat((Stream)itemStore.values()).hasSize(tasks);
        ((ObjectAssert)Assertions.assertThat((Object)itemStore.get("pods/test-pod/123")).isNotNull()).extracting(pod -> pod.getMetadata().getResourceVersion()).isEqualTo((Object)"123");
    }

    private static String podToKey(Pod pod) {
        return pod.getFullResourceName() + "/" + pod.getMetadata().getName() + "/" + pod.getMetadata().getResourceVersion();
    }

    private static /* synthetic */ Runnable lambda$parallelStore$1(ItemStore itemStore, CountDownLatch latch, int i) {
        return () -> {
            Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).withResourceVersion(Integer.toString(i))).endMetadata()).build();
            String key = itemStore.getKey((Object)pod);
            Assertions.assertThat((Object)itemStore.put(key, (Object)pod)).isNull();
            Assertions.assertThat((String)key).isEqualTo("pods/test-pod/" + i);
            latch.countDown();
        };
    }
}

