package io.fabric8.kubernetes.client;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RequestConfigFluent<A extends RequestConfigFluent<A>> extends BaseFluent<A>{
  public RequestConfigFluent() {
  }
  
  public RequestConfigFluent(RequestConfig instance) {
    this.copyInstance(instance);
  }
  private String impersonateUsername;
  private List<String> impersonateGroups;
  private Map<String,List<String>> impersonateExtras;
  private Integer watchReconnectInterval;
  private Integer watchReconnectLimit;
  private Integer uploadRequestTimeout;
  private Integer requestRetryBackoffLimit;
  private Integer requestRetryBackoffInterval;
  private Integer requestTimeout;
  private Long scaleTimeout;
  private Integer loggingInterval;
  
  protected void copyInstance(RequestConfig instance) {
    instance = (instance != null ? instance : new RequestConfig());
    if (instance != null) {
          this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
          this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
          this.withRequestTimeout(instance.getRequestTimeout());
          this.withScaleTimeout(instance.getScaleTimeout());
          this.withLoggingInterval(instance.getLoggingInterval());
          this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
          this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
          this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
          this.withImpersonateUsername(instance.getImpersonateUsername());
          this.withImpersonateGroups(instance.getImpersonateGroups());
          this.withImpersonateExtras(instance.getImpersonateExtras());
        }
  }
  
  public String getImpersonateUsername() {
    return this.impersonateUsername;
  }
  
  public A withImpersonateUsername(String impersonateUsername) {
    this.impersonateUsername = impersonateUsername;
    return (A) this;
  }
  
  public boolean hasImpersonateUsername() {
    return this.impersonateUsername != null;
  }
  
  public A withImpersonateGroups(java.lang.String... impersonateGroups) {
    if (this.impersonateGroups != null) {
        this.impersonateGroups.clear();
        _visitables.remove("impersonateGroups");
    }
    if (impersonateGroups != null) {
      for (String item : impersonateGroups) {
        this.addToImpersonateGroups(item);
      }
    }
    return (A) this;
  }
  
  public String[] getImpersonateGroups() {
    int size = impersonateGroups != null ? impersonateGroups.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : impersonateGroups) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToImpersonateGroups(int index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.add(index, item);
    return (A)this;
  }
  
  public A setToImpersonateGroups(int index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.set(index, item); return (A)this;
  }
  
  public A addToImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  
  public A addAllToImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  
  public A removeFromImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) return (A)this;
    for (String item : items) { this.impersonateGroups.remove(item);} return (A)this;
  }
  
  public A removeAllFromImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) return (A)this;
    for (String item : items) { this.impersonateGroups.remove(item);} return (A)this;
  }
  
  public boolean hasImpersonateGroups() {
    return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
  }
  
  public A addToImpersonateExtras(String key,List<String> value) {
    if(this.impersonateExtras == null && key != null && value != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(key != null && value != null) {this.impersonateExtras.put(key, value);} return (A)this;
  }
  
  public A addToImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null && map != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(map != null) { this.impersonateExtras.putAll(map);} return (A)this;
  }
  
  public A removeFromImpersonateExtras(String key) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(key != null && this.impersonateExtras != null) {this.impersonateExtras.remove(key);} return (A)this;
  }
  
  public A removeFromImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.impersonateExtras != null){this.impersonateExtras.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<String>> getImpersonateExtras() {
    return this.impersonateExtras;
  }
  
  public <K,V>A withImpersonateExtras(Map<String,List<String>> impersonateExtras) {
    if (impersonateExtras == null) {
      this.impersonateExtras = null;
    } else {
      this.impersonateExtras = new LinkedHashMap(impersonateExtras);
    }
    return (A) this;
  }
  
  public boolean hasImpersonateExtras() {
    return this.impersonateExtras != null;
  }
  
  public Integer getWatchReconnectInterval() {
    return this.watchReconnectInterval;
  }
  
  public A withWatchReconnectInterval(Integer watchReconnectInterval) {
    this.watchReconnectInterval = watchReconnectInterval;
    return (A) this;
  }
  
  public boolean hasWatchReconnectInterval() {
    return this.watchReconnectInterval != null;
  }
  
  public Integer getWatchReconnectLimit() {
    return this.watchReconnectLimit;
  }
  
  public A withWatchReconnectLimit(Integer watchReconnectLimit) {
    this.watchReconnectLimit = watchReconnectLimit;
    return (A) this;
  }
  
  public boolean hasWatchReconnectLimit() {
    return this.watchReconnectLimit != null;
  }
  
  public Integer getUploadRequestTimeout() {
    return this.uploadRequestTimeout;
  }
  
  public A withUploadRequestTimeout(Integer uploadRequestTimeout) {
    this.uploadRequestTimeout = uploadRequestTimeout;
    return (A) this;
  }
  
  public boolean hasUploadRequestTimeout() {
    return this.uploadRequestTimeout != null;
  }
  
  public Integer getRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit;
  }
  
  public A withRequestRetryBackoffLimit(Integer requestRetryBackoffLimit) {
    this.requestRetryBackoffLimit = requestRetryBackoffLimit;
    return (A) this;
  }
  
  public boolean hasRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit != null;
  }
  
  public Integer getRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval;
  }
  
  public A withRequestRetryBackoffInterval(Integer requestRetryBackoffInterval) {
    this.requestRetryBackoffInterval = requestRetryBackoffInterval;
    return (A) this;
  }
  
  public boolean hasRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval != null;
  }
  
  public Integer getRequestTimeout() {
    return this.requestTimeout;
  }
  
  public A withRequestTimeout(Integer requestTimeout) {
    this.requestTimeout = requestTimeout;
    return (A) this;
  }
  
  public boolean hasRequestTimeout() {
    return this.requestTimeout != null;
  }
  
  public Long getScaleTimeout() {
    return this.scaleTimeout;
  }
  
  public A withScaleTimeout(Long scaleTimeout) {
    this.scaleTimeout = scaleTimeout;
    return (A) this;
  }
  
  public boolean hasScaleTimeout() {
    return this.scaleTimeout != null;
  }
  
  public Integer getLoggingInterval() {
    return this.loggingInterval;
  }
  
  public A withLoggingInterval(Integer loggingInterval) {
    this.loggingInterval = loggingInterval;
    return (A) this;
  }
  
  public boolean hasLoggingInterval() {
    return this.loggingInterval != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RequestConfigFluent that = (RequestConfigFluent) o;
    if (!java.util.Objects.equals(impersonateUsername, that.impersonateUsername)) return false;
    if (!java.util.Objects.equals(impersonateGroups, that.impersonateGroups)) return false;
    if (!java.util.Objects.equals(impersonateExtras, that.impersonateExtras)) return false;
    if (!java.util.Objects.equals(watchReconnectInterval, that.watchReconnectInterval)) return false;
    if (!java.util.Objects.equals(watchReconnectLimit, that.watchReconnectLimit)) return false;
    if (!java.util.Objects.equals(uploadRequestTimeout, that.uploadRequestTimeout)) return false;
    if (!java.util.Objects.equals(requestRetryBackoffLimit, that.requestRetryBackoffLimit)) return false;
    if (!java.util.Objects.equals(requestRetryBackoffInterval, that.requestRetryBackoffInterval)) return false;
    if (!java.util.Objects.equals(requestTimeout, that.requestTimeout)) return false;
    if (!java.util.Objects.equals(scaleTimeout, that.scaleTimeout)) return false;
    if (!java.util.Objects.equals(loggingInterval, that.loggingInterval)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(impersonateUsername,  impersonateGroups,  impersonateExtras,  watchReconnectInterval,  watchReconnectLimit,  uploadRequestTimeout,  requestRetryBackoffLimit,  requestRetryBackoffInterval,  requestTimeout,  scaleTimeout,  loggingInterval,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (impersonateUsername != null) { sb.append("impersonateUsername:"); sb.append(impersonateUsername + ","); }
    if (impersonateGroups != null && !impersonateGroups.isEmpty()) { sb.append("impersonateGroups:"); sb.append(impersonateGroups + ","); }
    if (impersonateExtras != null && !impersonateExtras.isEmpty()) { sb.append("impersonateExtras:"); sb.append(impersonateExtras + ","); }
    if (watchReconnectInterval != null) { sb.append("watchReconnectInterval:"); sb.append(watchReconnectInterval + ","); }
    if (watchReconnectLimit != null) { sb.append("watchReconnectLimit:"); sb.append(watchReconnectLimit + ","); }
    if (uploadRequestTimeout != null) { sb.append("uploadRequestTimeout:"); sb.append(uploadRequestTimeout + ","); }
    if (requestRetryBackoffLimit != null) { sb.append("requestRetryBackoffLimit:"); sb.append(requestRetryBackoffLimit + ","); }
    if (requestRetryBackoffInterval != null) { sb.append("requestRetryBackoffInterval:"); sb.append(requestRetryBackoffInterval + ","); }
    if (requestTimeout != null) { sb.append("requestTimeout:"); sb.append(requestTimeout + ","); }
    if (scaleTimeout != null) { sb.append("scaleTimeout:"); sb.append(scaleTimeout + ","); }
    if (loggingInterval != null) { sb.append("loggingInterval:"); sb.append(loggingInterval); }
    sb.append("}");
    return sb.toString();
  }
  

}