/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecConfigBuilder;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.lib.FileSystem;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

class ConfigTest {
    private static final String TEST_KUBECONFIG_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig"));
    private static final String TEST_EC_KUBECONFIG_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-ec-kubeconfig"));
    private static final String TEST_NAMESPACE_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-namespace"));
    private static final String TEST_KUBECONFIG_EXEC_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec"));
    private static final String TEST_TOKEN_GENERATOR_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/token-generator"));
    private static final String TEST_TOKEN_GENERATOR_FILE_WITH_SPACES = Utils.filePath((URL)ConfigTest.class.getResource("/token-generator with spaces"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-null-args"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-null-args"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES_WIN = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-with-spaces-windows"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-with-spaces"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES_WIN = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-args-with-spaces-windows"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-args-with-spaces"));
    private static final String TEST_KUBECONFIG_NO_CURRENT_CONTEXT_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-nocurrentctxt.yml"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-cert-auth"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-cert-auth"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH_EC_INVALID = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-cert-auth-ec-invalid"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH_EC_INVALID = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-cert-auth-ec-invalid"));
    private static final String TEST_CERT_GENERATOR_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/cert-generator"));

    ConfigTest() {
    }

    @Test
    void testWithMultipleKubeConfigAndOverrideContext() {
        try {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE + File.pathSeparator + "some-other-file");
            Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/root");
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"production")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"supertoken")).satisfies(new ThrowingConsumer[]{c -> {
                AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator));
            }})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()});
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void testWithNamespacePath() {
        try {
            System.setProperty("kubeconfig", "nokubeconfigfile");
            System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
            System.setProperty("kubernetes.master", "http://somehost:80");
            Config config = new Config();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testnsfrompath");
        }
        finally {
            System.clearProperty("kubeconfig");
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
        }
    }

    @Test
    void testWithNonExistingNamespacePath() {
        try {
            System.setProperty("kubeconfig", "nokubeconfigfile");
            System.setProperty("kubenamespace", "nonamespace");
            System.setProperty("kubernetes.master", "http://somehost:80");
            Config config = new Config();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", null);
        }
        finally {
            System.clearProperty("kubeconfig");
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
        }
    }

    @Test
    void testWithNamespacePathAndSystemProperties() {
        try {
            System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
            System.setProperty("kubernetes.master", "http://somehost:80");
            System.setProperty("kubernetes.namespace", "testns");
            Config config = new Config();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns");
        }
        finally {
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
        }
    }

    @Test
    void testWithKubeConfigAndNoContext() {
        try {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_NO_CURRENT_CONTEXT_FILE);
            Config config = new Config();
            ((ListAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("currentContext", null)).hasFieldOrPropertyWithValue("namespace", null)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).extracting(Config::getContexts).asInstanceOf(InstanceOfAssertFactories.list(NamedContext.class))).hasSize(3);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void testWithNamespacePathAndSystemPropertiesAndBuilder() {
        try {
            System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
            System.setProperty("kubernetes.master", "http://somehost:80");
            System.setProperty("kubernetes.namespace", "tobeoverriden");
            Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns2");
        }
        finally {
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
        }
    }

    @Test
    void testWithCustomHeader() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("user-id", "test-user");
        customHeaders.put("cluster-id", "test-cluster");
        Config config = ((ConfigBuilder)new ConfigBuilder().withCustomHeaders(customHeaders)).build();
        ((MapAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).extracting(Config::getCustomHeaders).asInstanceOf(InstanceOfAssertFactories.MAP)).hasSize(2);
    }

    @Test
    void shouldSetImpersonateUsernameAndGroupFromSystemProperty() {
        try {
            System.setProperty("kubernetes.impersonate.username", "username");
            System.setProperty("kubernetes.impersonate.group", "group");
            HashMap<String, List<String>> extras = new HashMap<String, List<String>>();
            extras.put("c", Collections.singletonList("d"));
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withImpersonateUsername("a")).withImpersonateExtras(extras)).build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("requestConfig.impersonateUsername", (Object)"a")).hasFieldOrPropertyWithValue("requestConfig.impersonateGroups", (Object)new String[]{"group"})).hasFieldOrPropertyWithValue("requestConfig.impersonateExtras", Collections.singletonMap("c", Collections.singletonList("d")));
        }
        finally {
            System.clearProperty("kubernetes.impersonate.username");
            System.clearProperty("kubernetes.impersonate.group");
        }
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    void honorClientAuthenticatorCommandsOnWindows() {
        try {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE);
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO WORLD");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void honorClientAuthenticatorCommands() throws Exception {
        try {
            Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
            System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE);
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO WORLD");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void should_accept_client_authentication_commands_with_null_args() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS);
            }
            Config config = Config.autoConfigure(null);
            Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void testClientAuthenticationWithCert() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_CERT_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("clientCertData", (Object)"CERT DATA")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"KEY DATA");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void testClientAuthenticationWithCertAndECInvalid() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH_EC_INVALID);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_CERT_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH_EC_INVALID);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("clientCertData", null)).hasFieldOrPropertyWithValue("clientKeyData", null);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void should_accept_client_authentication_commands_args_with_spaces() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES_WIN);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE_WITH_SPACES, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO W O R L D");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void should_accept_client_authentication_commands_with_spaces() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES_WIN);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE_WITH_SPACES, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO WORLD");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void shouldBeUsedTokenSuppliedByProvider() {
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withOauthToken("oauthToken")).withOauthTokenProvider(() -> "PROVIDER_TOKEN")).build();
        Assertions.assertThat((String)config.getOauthToken()).isEqualTo("oauthToken");
    }

    @Test
    void testKubeConfigWithAuthConfigProvider() throws URISyntaxException {
        try {
            System.setProperty("kubeconfig", new File(this.getClass().getResource("/test-kubeconfig").toURI()).getAbsolutePath());
            Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/mmosley");
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"eyJraWQiOiJDTj1vaWRjaWRwLnRyZW1vbG8ubGFuLCBPVT1EZW1vLCBPPVRybWVvbG8gU2VjdXJpdHksIEw9QXJsaW5ndG9uLCBTVD1WaXJnaW5pYSwgQz1VUy1DTj1rdWJlLWNhLTEyMDIxNDc5MjEwMzYwNzMyMTUyIiwiYWxnIjoiUlMyNTYifQ.eyJpc3MiOiJodHRwczovL29pZGNpZHAudHJlbW9sby5sYW46ODQ0My9hdXRoL2lkcC9PaWRjSWRQIiwiYXVkIjoia3ViZXJuZXRlcyIsImV4cCI6MTQ4MzU0OTUxMSwianRpIjoiMm96US15TXdFcHV4WDlHZUhQdy1hZyIsImlhdCI6MTQ4MzU0OTQ1MSwibmJmIjoxNDgzNTQ5MzMxLCJzdWIiOiI0YWViMzdiYS1iNjQ1LTQ4ZmQtYWIzMC0xYTAxZWU0MWUyMTgifQ.w6p4J_6qQ1HzTG9nrEOrubxIMb9K5hzcMPxc9IxPx2K4xO9l-oFiUw93daH3m5pluP6K7eOE6txBuRVfEcpJSwlelsOsW8gb8VJcnzMS9EnZpeA0tW_p-mnkFc3VcfyXuhe5R3G7aa5d8uHv70yJ9Y3-UhjiN9EhpMdfPAoEB9fYKKkJRzF7utTTIPGrSaSU6d2pcpfYKaxIwePzEkT4DfcQthoZdy9ucNvvLoi1DIC-UocFD8HLs8LYKEqSxQvOcvnThbObJ9af71EwmuE21fO5KzMW20KtAeget1gnldOosPtz1G5EwvaQ401-RPQzPGMVBld0_zMCAwZttJ4knw");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void testEmptyConfig() {
        Config emptyConfig = null;
        emptyConfig = Config.empty();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)emptyConfig).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).hasFieldOrPropertyWithValue("errorMessages", Collections.emptyMap())).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)e.getUserAgent()).isNotNull();
        }});
    }

    @Test
    void deprecatedOldConfigConstructor() {
        Config config = new Config("https://api.example.testing:6443", "v1", "ns1", Boolean.valueOf(true), true, "ca.crt", "certificate-authority-data", "client.crt", "client-authority-data", "client-key.crt", "client-key-data", "EC", "client-key-passphrase", "test-user", "secret", "sha256~secret", "sha256~auto-token", 500, 5, 5000, 5000, 0L, 100000L, 10000, 5, 10, "http://proxy-url", "https://proxy-url", new String[]{"https://noproxy-url1"}, Collections.emptyMap(), "fabric8-kubernetes-client/ConfigTest", new TlsVersion[]{TlsVersion.TLS_1_3}, 10000L, "proxy-username", "proxy-password", "truststore.jks", "truststore-password", "k8s.keystore", "keystore-password", "jane.doe@example.com", new String[]{"developers"}, Collections.singletonMap("scope", Arrays.asList("view", "development")));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("apiVersion", (Object)"v1")).hasFieldOrPropertyWithValue("namespace", (Object)"ns1")).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api.example.testing:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("caCertFile", (Object)"ca.crt")).hasFieldOrPropertyWithValue("caCertData", (Object)"certificate-authority-data")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"client.crt")).hasFieldOrPropertyWithValue("clientCertData", (Object)"client-authority-data")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"client-key.crt")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"client-key-data")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"client-key-passphrase")).hasFieldOrPropertyWithValue("username", (Object)"test-user")).hasFieldOrPropertyWithValue("password", (Object)"secret")).hasFieldOrPropertyWithValue("oauthToken", (Object)"sha256~secret")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"sha256~auto-token")).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-url")).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-url")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"https://noproxy-url1"})).hasFieldOrPropertyWithValue("proxyUsername", (Object)"proxy-username")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"proxy-password")).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"truststore.jks")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"truststore-password")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"k8s.keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"keystore-password")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)5)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"client-key-passphrase")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)100000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)10000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateUsername", (Object)"jane.doe@example.com")).satisfies(new ThrowingConsumer[]{e -> {
            ObjectArrayAssert cfr_ignored_0 = (ObjectArrayAssert)Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developers"});
        }})).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("scope", Arrays.asList("view", "development")))).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("fabric8-kubernetes-client/ConfigTest")});
    }

    private void assertConfig(Config config, String masterUrl, String namespace, boolean autoToken) {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)masterUrl)).hasFieldOrPropertyWithValue("namespace", (Object)namespace)).hasFieldOrPropertyWithValue("username", (Object)"user")).hasFieldOrPropertyWithValue("password", (Object)"pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"no-proxy-url1.io", "no-proxy-url2.io"});
        if (autoToken) {
            Assertions.assertThat((String)config.getAutoOAuthToken()).isEqualTo("token");
        } else {
            Assertions.assertThat((String)config.getOauthToken()).isEqualTo("token");
        }
    }

    @Test
    void testGetAuthenticatorCommandFromExecConfig() throws IOException {
        File commandFolder = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        File commandFile = new File(commandFolder, "aws");
        Files.createFile(commandFile.toPath(), new FileAttribute[0]);
        String systemPathValue = this.getTestPathValue(commandFolder);
        ExecConfig execConfig = ((ExecConfigBuilder)((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().withApiVersion("client.authentication.k8s.io/v1alpha1")).addToArgs(new String[]{"--region", "us-west2", "eks", "get-token", "--cluster-name", "api-eks.example.com"})).withCommand("aws")).build();
        List processBuilderArgs = Config.getAuthenticatorCommandFromExecConfig((ExecConfig)execConfig, (File)new File("~/.kube/config"), (String)systemPathValue);
        ((ListAssert)Assertions.assertThat((List)processBuilderArgs).isNotNull()).hasSize(3);
        this.assertPlatformPrefixes(processBuilderArgs);
        List<String> commandParts = Arrays.asList(((String)processBuilderArgs.get(2)).split(" "));
        Assertions.assertThat(commandParts).containsExactly((Object[])new String[]{commandFile.getAbsolutePath(), "--region", "us-west2", "eks", "get-token", "--cluster-name", "api-eks.example.com"});
    }

    @Test
    void testGetAuthenticatorCommandFromExecConfigNullArgs() throws IOException {
        File commandFolder = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        File commandFile = new File(commandFolder, "gke-gcloud-auth-plugin");
        String systemPathValue = this.getTestPathValue(commandFolder);
        ExecConfig execConfigNoArgs = ((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().withApiVersion("client.authentication.k8s.io/v1alpha1")).withCommand(commandFile.getPath())).build();
        execConfigNoArgs.setArgs(null);
        List processBuilderArgs = Config.getAuthenticatorCommandFromExecConfig((ExecConfig)execConfigNoArgs, null, (String)systemPathValue);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)processBuilderArgs).isNotNull()).hasSize(3)).satisfies(new ThrowingConsumer[]{pb -> Assertions.assertThat((String)((String)pb.get(2))).isEqualTo(commandFile.getPath())});
        this.assertPlatformPrefixes(processBuilderArgs);
    }

    private void assertPlatformPrefixes(List<String> processBuilderArgs) {
        List platformArgsExpected = Utils.getCommandPlatformPrefix();
        ((ListAssert)Assertions.assertThat(processBuilderArgs).satisfies(new ThrowingConsumer[]{p -> Assertions.assertThat((String)((String)p.get(0))).isEqualTo((String)platformArgsExpected.get(0))})).satisfies(new ThrowingConsumer[]{p -> Assertions.assertThat((String)((String)p.get(1))).isEqualTo((String)platformArgsExpected.get(1))});
    }

    private String getTestPathValue(File commandFolder) {
        if (Utils.isWindowsOperatingSystem()) {
            return "C:\\Program Files\\Java\\jdk14.0_23\\bin" + File.pathSeparator + commandFolder.getAbsolutePath() + File.pathSeparator + "C:\\Program Files\\Apache Software Foundation\\apache-maven-3.3.1";
        }
        return "/usr/java/jdk-14.0.1/bin" + File.pathSeparator + commandFolder.getAbsolutePath() + File.pathSeparator + "/opt/apache-maven/bin";
    }

    @Test
    void refresh_whenOAuthTokenSourceSetToUser_thenConfigUnchanged() {
        Config config = ((ConfigBuilder)new ConfigBuilder().withOauthToken("token-from-user")).build();
        Config updatedConfig = config.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)updatedConfig).isSameAs((Object)config)).hasFieldOrPropertyWithValue("oauthToken", (Object)"token-from-user");
    }

    @Test
    void givenEmptyKubeConfig_whenConfigCreated_thenShouldNotProduceNPE() throws URISyntaxException {
        try {
            System.setProperty("kubeconfig", new File(Objects.requireNonNull(this.getClass().getResource("/test-empty-kubeconfig")).toURI()).getAbsolutePath());
            Config config = new ConfigBuilder().build();
            Assertions.assertThat((Object)config).isNotNull();
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    private static abstract class AutoConfiguredDisabledScenarios {
        private final NamedContext userConfiguredNamedContext = ((NamedContextBuilder)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextBuilder)new NamedContextBuilder().withName("context1")).withNewContext().withCluster("api-test-openshiftapps-com:6443")).withUser("testuser/api-test-openshiftapps-com:6443")).endContext()).build();

        private AutoConfiguredDisabledScenarios() {
        }

        private ConfigBuilder createConfigBuilderWithUserConfiguration() {
            return (ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://api-test.openshiftapps.com:6443")).withContexts(new NamedContext[]{this.userConfiguredNamedContext})).withCurrentContext(this.userConfiguredNamedContext)).withMaxConcurrentRequests(Integer.valueOf(30))).withMaxConcurrentRequestsPerHost(Integer.valueOf(10))).withTrustCerts()).withDisableHostnameVerification()).withClientKeyAlgo("EC")).withWatchReconnectInterval(Integer.valueOf(500))).withWatchReconnectLimit(Integer.valueOf(10))).withConnectionTimeout(Integer.valueOf(1000))).withRequestTimeout(Integer.valueOf(1000))).withScaleTimeout(Long.valueOf(1000L))).withLoggingInterval(Integer.valueOf(1000))).withWebsocketPingInterval(Long.valueOf(10000L))).withUploadRequestTimeout(Integer.valueOf(1000))).withImpersonateExtras(Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).withHttp2Disable(Boolean.valueOf(true))).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3})).withCurrentContext(this.userConfiguredNamedContext)).withImpersonateGroups(new String[]{"developer", "admin"})).withUserAgent("custom-user-agent");
        }

        void assertConfigUsesDefaultValues(Config configWithoutAutoConfigure) {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)configWithoutAutoConfigure).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> {
                AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)e.getUserAgent()).isNotNull();
            }});
        }

        void assertConfigUsesUserProvidedValues(Config config) {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api-test.openshiftapps.com:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.singletonList(this.userConfiguredNamedContext))).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)30)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)10)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)1000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).hasFieldOrPropertyWithValue("http2Disable", (Object)true)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)e.getCurrentContext()).isEqualTo((Object)this.userConfiguredNamedContext);
            }})).satisfies(new ThrowingConsumer[]{e -> {
                ObjectArrayAssert cfr_ignored_0 = (ObjectArrayAssert)Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developer", "admin"});
            }})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("custom-user-agent")});
        }

        @Nested
        @DisplayName(value="kubernetes.disable.autoConfig=true")
        class AutoConfigDisabledViaProperty {
            AutoConfigDisabledViaProperty() {
            }

            @BeforeEach
            void setUp() {
                System.setProperty("kubernetes.disable.autoConfig", "true");
            }

            @Test
            @DisplayName(value="no user configuration, the use default values")
            void whenConfigDisabledViaPropertyAndUserProvidesNoConfiguration_thenUseConfigDefaultValues() {
                AutoConfiguredDisabledScenarios.this.assertConfigUsesDefaultValues(new ConfigBuilder().build());
            }

            @Test
            @DisplayName(value="user configuration via builder, the user configuration used")
            void whenConfigDisabledViaPropertyAndUserProvidesConfigurationViaConfigBuilder_thenUseConfigDefaultValues() {
                AutoConfiguredDisabledScenarios.this.assertConfigUsesUserProvidedValues(AutoConfiguredDisabledScenarios.this.createConfigBuilderWithUserConfiguration().build());
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubernetes.disable.autoConfig");
            }
        }
    }

    @Nested
    @DisplayName(value="autoConfigure disabled")
    class NoAutoConfiguration {
        NoAutoConfiguration() {
        }

        @Nested
        @DisplayName(value="kubeconfig present should be ignored with auto configuration disabled")
        class KubeConfigPresent
        extends AutoConfiguredDisabledScenarios {
            KubeConfigPresent() {
            }

            @BeforeEach
            void setUp() throws IOException {
                if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                    System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS);
                } else {
                    Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                    System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS);
                }
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubeconfig");
            }
        }

        @Nested
        @DisplayName(value="system properties present should be ignored with auto configuration disabled")
        class SystemPropertiesConfigured
        extends AutoConfiguredDisabledScenarios {
            SystemPropertiesConfigured() {
            }

            @BeforeEach
            void setUp() {
                System.setProperty("kubernetes.master", "http://somehost:80");
                System.setProperty("kubernetes.namespace", "testns");
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubernetes.master");
                System.clearProperty("kubernetes.namespace");
            }
        }
    }

    @Nested
    @DisplayName(value="Config.getHomeDir")
    class GetHomeDir {
        GetHomeDir() {
        }

        @Test
        @EnabledOnOs(value={OS.WINDOWS})
        void shouldUseHomeEnvVariable_WhenEnabledOnWindows_WhenHomeEnvVariableIsSet() {
            HashMap<String, String> envVars = new HashMap<String, String>();
            envVars.put("HOMEDRIVE", "C:\\Users\\");
            envVars.put("HOMEPATH", "user");
            envVars.put("HOME", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
            Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
        }

        @Test
        void shouldReturnUserHomeProp_WhenHomeEnvVariablesAreNotSet() {
            String userHomePropToRestore = System.getProperty("user.home");
            try {
                System.setProperty("user.home", "/home/user");
                Map emptyEnvVars = Collections.emptyMap();
                Assertions.assertThat((String)Config.getHomeDir(f -> true, emptyEnvVars::get)).isEqualTo("/home/user");
            }
            finally {
                System.setProperty("user.home", userHomePropToRestore);
            }
        }

        @Nested
        @DisplayName(value="os.name=Windows")
        class OsNameWindows {
            private String osNamePropToRestore;

            OsNameWindows() {
            }

            @BeforeEach
            void setUp() {
                this.osNamePropToRestore = System.getProperty("os.name");
                System.setProperty("os.name", "Windows");
            }

            @Test
            void shouldUseHomeDriveHomePathOnWindows_WhenHomeEnvVariableIsNotSet() {
                HashMap<String, String> envVars = new HashMap<String, String>();
                envVars.put("HOMEDRIVE", "C:\\Users\\");
                envVars.put("HOMEPATH", "user");
                envVars.put("USERPROFILE", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
                Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user");
            }

            @Test
            void shouldUseUserprofileOnWindows_WhenHomeHomeDriveHomePathEnvVariablesAreNotSet() {
                HashMap<String, String> envVars = new HashMap<String, String>();
                envVars.put("USERPROFILE", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
                Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
            }

            @Test
            void shouldUseHomeEnvVariableOnWindows_WhenHomeEnvVariableIsSet() {
                HashMap<String, String> envVars = new HashMap<String, String>();
                envVars.put("HOMEDRIVE", "C:\\Users\\");
                envVars.put("HOMEPATH", "user");
                envVars.put("HOME", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
                Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
            }

            @AfterEach
            void tearDown() {
                System.setProperty("os.name", this.osNamePropToRestore);
            }
        }
    }

    @Nested
    @DisplayName(value="load fromKubeConfig")
    class FromKubeConfig {
        FromKubeConfig() {
        }

        @BeforeEach
        void setUp() {
            System.clearProperty("kubeconfig");
            System.clearProperty("kubernetes.master");
        }

        @Test
        @DisplayName(value="standard kubeconfig file")
        void testFromKubeconfigContent() throws IOException {
            Config config = Config.fromKubeconfig((String)this.prepareKubeConfigYamlFrom(TEST_KUBECONFIG_FILE));
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("file", null)).isSameAs((Object)config.refresh());
        }

        @Test
        @DisplayName(value="kubeconfig with EC Private Data in client key")
        void testFromKubeconfigKeyAlgo() throws IOException {
            Config config = Config.fromKubeconfig((String)this.prepareKubeConfigYamlFrom(TEST_EC_KUBECONFIG_FILE));
            Assertions.assertThat((String)config.getClientKeyAlgo()).isEqualTo("EC");
        }

        private String prepareKubeConfigYamlFrom(String filePath) throws IOException {
            File configFile = new File(filePath);
            return String.join((CharSequence)System.lineSeparator(), Files.readAllLines(configFile.toPath()));
        }
    }

    @Nested
    @DisplayName(value="kubeconfig present")
    class KubeConfigPresent {
        KubeConfigPresent() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
            System.clearProperty("kubernetes.namespace");
        }

        @Test
        @DisplayName(value="new Config() should auto configure from kubeconfig")
        void noArgConstructor_shouldAutoConfigureFromKubeConfig() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new Config()).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token")).satisfies(new ThrowingConsumer[]{c -> {
                AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator));
            }})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()})).hasFieldOrPropertyWithValue("file", (Object)new File(TEST_KUBECONFIG_FILE));
        }

        @Test
        @DisplayName(value="Config.autoConfigure with overridden context")
        void testOverrideContext() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)Config.autoConfigure((String)"production/172-28-128-4:8443/root")).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"production")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"supertoken")).satisfies(new ThrowingConsumer[]{c -> {
                AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator));
            }})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()});
        }

        @Test
        @DisplayName(value="override via system property should get more precedence over kubeconfig")
        void testOverrideViaSystemProperties() {
            try {
                System.setProperty("kubernetes.master", "http://somehost:80");
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new Config()).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token")).hasFieldOrPropertyWithValue("file", (Object)new File(TEST_KUBECONFIG_FILE))).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()});
            }
            finally {
                System.clearProperty("kubernetes.master");
            }
        }

        @Test
        void testSystemPropertiesAndBuilderGetMorePrecedenceOverKubeconfig() {
            try {
                System.setProperty("kubernetes.master", "http://somehost:80");
                Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns2")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token");
            }
            finally {
                System.clearProperty("kubernetes.master");
            }
        }
    }

    @Nested
    @DisplayName(value="Inside Kubernetes cluster")
    class InCluster {
        InCluster() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", "/dev/null");
            System.clearProperty("kubernetes.master");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubeconfig");
        }

        @Test
        void testMasterUrlWithServiceAccount() {
            try {
                System.setProperty("KUBERNETES_SERVICE_HOST", "10.0.0.1");
                System.setProperty("KUBERNETES_SERVICE_PORT", "443");
                Config config = Config.autoConfigure(null);
                ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://10.0.0.1:443/")).hasFieldOrPropertyWithValue("file", null);
            }
            finally {
                System.clearProperty("KUBERNETES_SERVICE_HOST");
                System.clearProperty("KUBERNETES_SERVICE_PORT");
            }
        }

        @Test
        void testAutoConfig() {
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("file", null)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true);
            Config refresh = config.refresh();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)refresh).isNotSameAs((Object)config)).hasFieldOrPropertyWithValue("file", null)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true);
        }

        @Test
        void testMasterUrlWithServiceAccountIPv6() {
            try {
                System.setProperty("KUBERNETES_SERVICE_HOST", "2001:db8:1f70::999:de8:7648:6e8");
                System.setProperty("KUBERNETES_SERVICE_PORT", "443");
                Config config = Config.autoConfigure(null);
                ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://[2001:db8:1f70::999:de8:7648:6e8]:443/")).hasFieldOrPropertyWithValue("file", null);
            }
            finally {
                System.clearProperty("KUBERNETES_SERVICE_HOST");
                System.clearProperty("KUBERNETES_SERVICE_PORT");
            }
        }

        @Test
        @DisplayName(value="when ServiceAccount token file provided, then use it as autoOAuthToken")
        void whenServiceAccountTokenPathProvided_thenUseThatToken() {
            try {
                System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigTest.class.getResource("/test-serviceaccount/token")));
                Config config = new ConfigBuilder().build();
                Assertions.assertThat((String)config.getAutoOAuthToken()).contains(new CharSequence[]{"token-from-mounted-serviceaccount"});
            }
            finally {
                System.clearProperty("kubernetes.auth.serviceAccount.token");
            }
        }

        @Test
        @DisplayName(value="when ServiceAccount certificate file provided, then use it as caCertFile")
        void whenServiceAccountCertFilePathProvided_thenUseThatToken() {
            try {
                String certFilePath = Utils.filePath((URL)ConfigTest.class.getResource("/test-serviceaccount/ca.crt"));
                System.setProperty("kubernetes.certs.ca.file", certFilePath);
                Config config = new ConfigBuilder().build();
                Assertions.assertThat((String)config.getCaCertFile()).isEqualTo(certFilePath);
            }
            finally {
                System.clearProperty("kubernetes.certs.ca.file");
            }
        }

        @Test
        @DisplayName(value="when kubernetes.tryNamespacePath=false, then do NOT read ServiceAccount files")
        void whenTryNamespacePathDisabled_thenDoNotUseServiceAccountAttributes() {
            try {
                System.setProperty("kubernetes.auth.tryServiceAccount", "false");
                System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigTest.class.getResource("/test-serviceaccount/token")));
                Config config = new ConfigBuilder().build();
                Assertions.assertThat((String)config.getAutoOAuthToken()).isNull();
            }
            finally {
                System.clearProperty("kubernetes.auth.tryServiceAccount");
                System.clearProperty("kubernetes.auth.serviceAccount.token");
            }
        }
    }

    @Nested
    @DisplayName(value="ConfigBuilder")
    class BuilderConfigured {
        BuilderConfigured() {
        }

        @Test
        @DisplayName(value="when fields configured via builder, then fields get most precedence")
        void testWithBuilder() {
            Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withApiVersion("v1")).withNamespace("testns")).withOauthToken("token")).withUsername("user")).withPassword("pass")).withTrustCerts(Boolean.valueOf(true))).withDisableHostnameVerification(Boolean.valueOf(true))).withCaCertFile("/path/to/cert")).withCaCertData("cacertdata")).withClientCertFile("/path/to/clientcert")).withClientCertData("clientcertdata")).withClientKeyFile("/path/to/clientkey")).withClientKeyData("clientkeydata")).withClientKeyAlgo("algo")).withClientKeyPassphrase("passphrase")).withMaxConcurrentRequests(Integer.valueOf(120))).withMaxConcurrentRequestsPerHost(Integer.valueOf(20))).withWatchReconnectInterval(Integer.valueOf(5000))).withWatchReconnectLimit(Integer.valueOf(5))).withRequestTimeout(Integer.valueOf(5000))).withUploadRequestTimeout(Integer.valueOf(600000))).withHttpProxy("httpProxy")).withHttpsProxy("httpsProxy")).withProxyUsername("proxyUsername")).withProxyPassword("proxyPassword")).withNoProxy(new String[]{"no-proxy-url1.io", "no-proxy-url2.io"})).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).withTrustStoreFile("/path/to/truststore")).withTrustStorePassphrase("truststorePassphrase")).withKeyStoreFile("/path/to/keystore")).withKeyStorePassphrase("keystorePassphrase")).withHttp2Disable(Boolean.valueOf(false))).withWebsocketPingInterval(Long.valueOf(1000L))).withConnectionTimeout(Integer.valueOf(1000))).withScaleTimeout(Long.valueOf(1000L))).build();
            ConfigTest.this.assertConfig(config, "http://somehost:80/", "testns", false);
        }

        @Test
        @DisplayName(value="no additional config, should use default value for webSocketPingInterval")
        void shouldHonorDefaultWebsocketPingInterval() {
            Config config = new ConfigBuilder().build();
            Assertions.assertThat((Long)config.getWebsocketPingInterval()).isEqualTo(30000L);
        }
    }

    @Nested
    @DisplayName(value="System Properties Configured")
    class SystemPropertiesConfigured {
        SystemPropertiesConfigured() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubernetes.master", "http://somehost:80");
            System.setProperty("kubernetes.namespace", "testns");
            System.setProperty("kubernetes.auth.token", "token");
            System.setProperty("kubernetes.auth.basic.username", "user");
            System.setProperty("kubernetes.auth.basic.password", "pass");
            System.setProperty("kubernetes.trust.certificates", "true");
            System.setProperty("kubernetes.disable.hostname.verification", "true");
            System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
            System.setProperty("kubernetes.certs.ca.data", "cacertdata");
            System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
            System.setProperty("kubernetes.certs.client.data", "clientcertdata");
            System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
            System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
            System.setProperty("kubernetes.certs.client.key.algo", "algo");
            System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
            System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
            System.setProperty("kubernetes.max.concurrent.requests", "120");
            System.setProperty("kubernetes.max.concurrent.requests.per.host", "20");
            System.setProperty("kubernetes.watch.reconnectInterval", "5000");
            System.setProperty("kubernetes.watch.reconnectLimit", "5");
            System.setProperty("kubernetes.request.timeout", "5000");
            System.setProperty("http.proxy", "httpProxy");
            System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
            System.setProperty("kubernetes.truststore.file", "/path/to/truststore");
            System.setProperty("kubernetes.truststore.passphrase", "truststorePassphrase");
            System.setProperty("kubernetes.keystore.file", "/path/to/keystore");
            System.setProperty("kubernetes.keystore.passphrase", "keystorePassphrase");
            System.setProperty("kubernetes.upload.request.timeout", "600000");
            System.setProperty("kubernetes.websocket.ping.interval", "1000");
            System.setProperty("kubernetes.connection.timeout", "1000");
            System.setProperty("kubernetes.scale.timeout", "1000");
            System.setProperty("https.proxy", "httpsProxy");
            System.setProperty("no.proxy", "no-proxy-url1.io,no-proxy-url2.io");
            System.setProperty("proxy.username", "proxyUsername");
            System.setProperty("proxy.password", "proxyPassword");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
            System.clearProperty("kubernetes.auth.token");
            System.clearProperty("kubernetes.auth.basic.username");
            System.clearProperty("kubernetes.auth.basic.password");
            System.clearProperty("kubernetes.trust.certificates");
            System.clearProperty("kubernetes.disable.hostname.verification");
            System.clearProperty("kubernetes.certs.ca.file");
            System.clearProperty("kubernetes.certs.ca.data");
            System.clearProperty("kubernetes.certs.client.file");
            System.clearProperty("kubernetes.certs.client.data");
            System.clearProperty("kubernetes.certs.client.key.file");
            System.clearProperty("kubernetes.certs.client.key.data");
            System.clearProperty("kubernetes.certs.client.key.algo");
            System.clearProperty("kubernetes.certs.client.key.passphrase");
            System.clearProperty("kubernetes.certs.client.key.file");
            System.clearProperty("kubernetes.max.concurrent.requests");
            System.clearProperty("kubernetes.max.concurrent.requests.per.host");
            System.clearProperty("kubernetes.watch.reconnectInterval");
            System.clearProperty("kubernetes.watch.reconnectLimit");
            System.clearProperty("kubernetes.request.timeout");
            System.clearProperty("http.proxy");
            System.clearProperty("kubernetes.tls.versions");
            System.clearProperty("kubernetes.truststore.file");
            System.clearProperty("kubernetes.truststore.passphrase");
            System.clearProperty("kubernetes.keystore.file");
            System.clearProperty("kubernetes.keystore.passphrase");
            System.clearProperty("kubernetes.upload.request.timeout");
            System.clearProperty("kubernetes.websocket.ping.interval");
            System.clearProperty("kubernetes.connection.timeout");
            System.clearProperty("kubernetes.scale.timeout");
            System.clearProperty("https.proxy");
            System.clearProperty("no.proxy");
            System.clearProperty("proxy.username");
            System.clearProperty("proxy.password");
        }

        @Test
        @DisplayName(value="no args Config constructor, should load from properties")
        void zeroArgumentConstructor_whenInvoked_shouldLoadFromProperties() {
            ConfigTest.this.assertConfig(new Config(), "http://somehost:80/", "testns", true);
        }

        @Test
        @DisplayName(value="ConfigBuilder, should load from properties")
        void configBuilder_whenInvoked_shouldLoadFromProperties() {
            ConfigTest.this.assertConfig(new ConfigBuilder().build(), "http://somehost:80/", "testns", true);
        }

        @Test
        @DisplayName(value="ConfigBuilder, with builder methods, should override properties")
        void configBuilder_withBuilderMethods_shouldOverrideFieldsConfiguredViaProperties() {
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost-via-builder:80")).withNamespace("testns-via-builder")).build();
            ConfigTest.this.assertConfig(config, "http://somehost-via-builder:80/", "testns-via-builder", true);
        }
    }
}

