/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.mockwebserver.DefaultMockServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpPutTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    protected abstract Class<? extends Exception> getConnectionFailedExceptionType();

    @Test
    @DisplayName(value="String body, should send a PUT request with body")
    public void putStringBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/put-string")).put("text/plain", "A string body").build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"PUT", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="InputStream body, should send a PUT request with body")
    public void putInputStreamBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/put-input-stream")).put("text/plain", (InputStream)new ByteArrayInputStream("A string body".getBytes(StandardCharsets.UTF_8)), -1L).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"PUT", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    public void expectFailure() throws IOException, URISyntaxException {
        try (ServerSocket serverSocket = new ServerSocket(0);
             HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            URI uri = AbstractHttpPutTest.uriForPath(serverSocket, "/put-failing");
            serverSocket.close();
            CompletableFuture response = client.sendAsync(client.newHttpRequestBuilder().put("text/plain", (InputStream)new ByteArrayInputStream("A string body".getBytes(StandardCharsets.UTF_8)), -1L).uri(uri).timeout(250L, TimeUnit.MILLISECONDS).build(), String.class);
            Assertions.assertThat((CompletableFuture)response).failsWithin(30L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withCauseInstanceOf(this.getConnectionFailedExceptionType());
        }
    }

    private static URI uriForPath(ServerSocket socket, String path) throws URISyntaxException {
        InetAddress httpServerAddress = socket.getInetAddress();
        return new URI(String.format("http://%s:%s%s", httpServerAddress.getHostName(), socket.getLocalPort(), path));
    }
}

