/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.mockwebserver.internal.MockSSLContextFactory;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.SimpleResponse;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Headers;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpClientProxyHttpsTest {
    private static SocketPolicy defaultResponseSocketPolicy;
    private static Map<ServerRequest, Queue<ServerResponse>> responses;
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        defaultResponseSocketPolicy = SocketPolicy.KEEP_OPEN;
        responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        MockWebServer okHttpMockWebServer = new MockWebServer();
        MockDispatcher dispatcher = new MockDispatcher(responses){

            public MockResponse peek() {
                return new MockResponse().setSocketPolicy(defaultResponseSocketPolicy);
            }
        };
        server = new DefaultMockServer(new Context(), okHttpMockWebServer, responses, (Dispatcher)dispatcher, true);
        server.start();
        okHttpMockWebServer.useHttps(MockSSLContextFactory.create().getSocketFactory(), true);
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="Proxied HttpClient adds required headers to the request")
    protected void proxyConfigurationAddsRequiredHeadersForHttps() throws Exception {
        final AtomicReference initialConnectRequest = new AtomicReference();
        ResponseProvider<String> bodyProvider = new ResponseProvider<String>(){

            public String getBody(RecordedRequest request) {
                return "";
            }

            public void setHeaders(Headers headers) {
            }

            public int getStatusCode(RecordedRequest request) {
                defaultResponseSocketPolicy = SocketPolicy.UPGRADE_TO_SSL_AT_END;
                if (request.getHeader("Proxy-Authorization") != null) {
                    initialConnectRequest.compareAndSet(null, request);
                    return 200;
                }
                return 407;
            }

            public Headers getHeaders() {
                return new Headers.Builder().add("Proxy-Authenticate", "Basic").build();
            }
        };
        responses.computeIfAbsent((ServerRequest)new SimpleRequest(HttpMethod.CONNECT, "/"), k -> new ArrayDeque()).add(new SimpleResponse(true, (ResponseProvider)bodyProvider, null, 0L, TimeUnit.SECONDS));
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().sslContext(null, SSLUtils.trustManagers(null, null, (boolean)true, null, null)).proxyAddress(new InetSocketAddress("localhost", server.getPort())).proxyAuthorization(HttpClientUtils.basicCredentials((String)"auth", (String)"cred"));
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(String.format("https://0.0.0.0:%s/not-found", server.getPort() + 1)).build(), String.class).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat(initialConnectRequest).doesNotHaveNullValue().hasValueMatching(r -> r.getHeader("Proxy-Authorization").equals("Basic YXV0aDpjcmVk"));
        }
    }
}

