/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.Test;

class BufferUtilTest {
    BufferUtilTest() {
    }

    @Test
    void toArrayFromBBWithArray() {
        ByteBuffer buffer = ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8));
        byte[] result = BufferUtil.toArray((ByteBuffer)buffer);
        Assertions.assertThat((byte[])result).asString(StandardCharsets.UTF_8).isEqualTo("hello");
    }

    @Test
    void toArrayFromBB() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(5);
        buffer.put((byte)104);
        buffer.put((byte)101);
        buffer.put((byte)108);
        buffer.put((byte)108);
        buffer.put((byte)111);
        buffer.rewind();
        byte[] result = BufferUtil.toArray((ByteBuffer)buffer);
        Assertions.assertThat((byte[])result).asString(StandardCharsets.UTF_8).isEqualTo("hello");
    }

    @Test
    void toArrayFromBBInPosition() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(12);
        buffer.position(7);
        buffer.put((byte)104);
        buffer.put((byte)101);
        buffer.put((byte)108);
        buffer.put((byte)108);
        buffer.put((byte)111);
        buffer.position(7);
        byte[] result = BufferUtil.toArray((ByteBuffer)buffer);
        Assertions.assertThat((byte[])result).asString(StandardCharsets.UTF_8).isEqualTo("hello");
    }

    @Test
    void toArrayFromMultipleBB() {
        ByteBuffer hello = ByteBuffer.allocateDirect(12);
        hello.position(7);
        hello.put((byte)104);
        hello.put((byte)101);
        hello.put((byte)108);
        hello.put((byte)108);
        hello.put((byte)111);
        hello.position(7);
        ByteBuffer space = ByteBuffer.allocateDirect(1);
        space.put((byte)32);
        space.rewind();
        ByteBuffer world = ByteBuffer.wrap("world".getBytes(StandardCharsets.UTF_8));
        byte[] result = BufferUtil.toArray(Arrays.asList(hello, space, world));
        Assertions.assertThat((byte[])result).asString(StandardCharsets.UTF_8).isEqualTo("hello world");
    }

    @Test
    void copyReturnsADifferentInstance() {
        ByteBuffer buffer = ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8));
        ByteBuffer result = BufferUtil.copy((ByteBuffer)buffer);
        ((AbstractByteArrayAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)result).isNotSameAs((Object)buffer)).extracting(BufferUtil::toArray).asInstanceOf(InstanceOfAssertFactories.BYTE_ARRAY)).asString(StandardCharsets.UTF_8).isEqualTo("hello");
    }

    @Test
    void copyReturnsInstanceWithSameContent() {
        ByteBuffer buffer = ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8));
        ByteBuffer result = BufferUtil.copy((ByteBuffer)buffer);
        ((AbstractByteArrayAssert)Assertions.assertThat((Comparable)result).extracting(BufferUtil::toArray).asInstanceOf(InstanceOfAssertFactories.BYTE_ARRAY)).asString(StandardCharsets.UTF_8).isEqualTo("hello");
    }

    @Test
    void copyReturnsInstanceWithSameContentRange() {
        ByteBuffer buffer = ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8));
        buffer.position(2);
        ByteBuffer result = BufferUtil.copy((ByteBuffer)buffer);
        ((AbstractByteArrayAssert)Assertions.assertThat((Comparable)result).extracting(BufferUtil::toArray).asInstanceOf(InstanceOfAssertFactories.BYTE_ARRAY)).asString(StandardCharsets.UTF_8).isEqualTo("llo");
    }

    @Test
    void copyReturnsInstancePreservingPositionOfOriginal() {
        ByteBuffer buffer = ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8));
        buffer.position(2);
        BufferUtil.copy((ByteBuffer)buffer);
        Assertions.assertThat((Comparable)buffer).extracting(Buffer::position).isEqualTo((Object)2);
    }

    @Test
    void copyWithNullReturnsNull() {
        Assertions.assertThat((Comparable)BufferUtil.copy(null)).isNull();
    }
}

