/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.cache.Indexer;
import io.fabric8.kubernetes.client.utils.ReflectUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Collections;
import java.util.List;

public interface Cache<T>
extends Indexer<T> {
    public static final String NAMESPACE_INDEX = "namespace";

    public static String metaNamespaceKeyFunc(Object obj) {
        try {
            ObjectMeta metadata;
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof ObjectMeta) {
                metadata = (ObjectMeta)obj;
            } else {
                metadata = ReflectUtils.objectMetadata(obj);
                if (metadata == null) {
                    throw new RuntimeException("Object is bad :" + obj);
                }
            }
            return Cache.namespaceKeyFunc(metadata.getNamespace(), metadata.getName());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String metaUidKeyFunc(HasMetadata obj) {
        if (obj == null || obj.getMetadata() == null) {
            return "";
        }
        String result = obj.getMetadata().getUid();
        return Utils.getNonNullOrElse(result, "");
    }

    public static String namespaceKeyFunc(String objectNamespace, String objectName) {
        if (Utils.isNullOrEmpty(objectNamespace)) {
            return objectName;
        }
        return objectNamespace + "/" + objectName;
    }

    public static List<String> metaNamespaceIndexFunc(Object obj) {
        try {
            ObjectMeta metadata = ReflectUtils.objectMetadata(obj);
            return metadata == null ? Collections.emptyList() : Collections.singletonList(metadata.getNamespace());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

