/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.model.jackson.UnmatchedFieldTypeModule;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.BaseRepresenter;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;

public class Serialization {
    public static final UnmatchedFieldTypeModule UNMATCHED_FIELD_TYPE_MODULE = new UnmatchedFieldTypeModule();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static volatile ObjectMapper YAML_MAPPER;

    private Serialization() {
    }

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static ObjectMapper yamlMapper() {
        if (YAML_MAPPER != null) return YAML_MAPPER;
        Class<Serialization> clazz = Serialization.class;
        synchronized (Serialization.class) {
            if (YAML_MAPPER != null) return YAML_MAPPER;
            YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));
            YAML_MAPPER.registerModules(new Module[]{UNMATCHED_FIELD_TYPE_MODULE});
            // ** MonitorExit[var0] (shouldn't be in output)
            return YAML_MAPPER;
        }
    }

    @Deprecated
    public static void clearYamlMapper() {
        YAML_MAPPER = null;
    }

    public static <T> String asJson(T object) {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> String asYaml(T object) {
        DumpSettings settings = DumpSettings.builder().setExplicitStart(true).setDefaultFlowStyle(FlowStyle.BLOCK).build();
        Dump yaml = new Dump(settings, (BaseRepresenter)new StandardRepresenter(settings){
            private boolean quote = true;

            protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    this.quote = false;
                    String str = (String)key;
                    if (str.length() == 1) {
                        char start = str.charAt(0);
                        this.quote = start == 'y' || start == 'Y' || start == 'n' || start == 'N';
                    }
                }
                Node nodeKey = this.representData(key);
                this.quote = true;
                return new NodeTuple(nodeKey, this.representData(entry.getValue()));
            }

            protected Node representScalar(Tag tag, String value, ScalarStyle style) {
                if (style == ScalarStyle.PLAIN) {
                    style = this.quote && tag == Tag.STR ? ScalarStyle.DOUBLE_QUOTED : this.defaultScalarStyle;
                }
                return new ScalarNode(tag, value, style);
            }
        });
        return yaml.dumpToString(JSON_MAPPER.convertValue(object, Object.class));
    }

    public static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    @Deprecated
    public static <T> T unmarshal(InputStream is, Map<String, String> parameters) {
        return Serialization.unmarshal(is, JSON_MAPPER, parameters);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    @Deprecated
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        return Serialization.unmarshal(is, mapper, new TypeReference<T>(){

            public Type getType() {
                return KubernetesResource.class;
            }
        }, parameters);
    }

    /*
     * Exception decompiling
     */
    private static <T> T unmarshal(InputStream is, ObjectMapper mapper, TypeReference<T> type, Map<String, String> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> T parseYaml(BufferedInputStream bis, ObjectMapper mapper, TypeReference<T> type) {
        Object result = null;
        ArrayList<KubernetesResource> listResult = null;
        Load yaml = new Load(LoadSettings.builder().build());
        Iterable objs = yaml.loadAllFromInputStream((InputStream)bis);
        for (Object obj : objs) {
            Object value = null;
            if (obj instanceof Map) {
                value = mapper.convertValue(obj, type);
            } else if (obj != null) {
                value = mapper.convertValue((Object)new RawExtension(obj), type);
            }
            if (value == null) continue;
            if (result == null) {
                result = value;
                continue;
            }
            if (listResult == null) {
                listResult = new ArrayList<KubernetesResource>();
                Serialization.accumulateResult(result, listResult);
            }
            Serialization.accumulateResult(value, listResult);
        }
        if (listResult != null) {
            return (T)listResult;
        }
        return (T)result;
    }

    private static <T> void accumulateResult(T result, List<KubernetesResource> listResult) {
        if (result instanceof KubernetesResourceList) {
            listResult.addAll(((KubernetesResourceList)result).getItems());
        } else {
            listResult.add((KubernetesResource)result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal(is);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(String str, Class<T> type) {
        return Serialization.unmarshal(str, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static <T> T unmarshal(String str, final Class<T> type, Map<String, String> parameters) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            }, parameters);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> type) {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    @Deprecated
    public static <T> T unmarshal(InputStream is, final Class<T> type, Map<String, String> parameters) {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        }, parameters);
    }

    public static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    @Deprecated
    public static <T> T unmarshal(InputStream is, TypeReference<T> type, Map<String, String> parameters) {
        return Serialization.unmarshal(is, JSON_MAPPER, type, parameters);
    }

    public static <T> T clone(T resource) {
        try {
            return (T)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString(resource), resource.getClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        JSON_MAPPER.registerModules(new Module[]{new JavaTimeModule(), UNMATCHED_FIELD_TYPE_MODULE});
        JSON_MAPPER.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
    }
}

