package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LeaderElectionConfigBuilder extends LeaderElectionConfigFluentImpl<LeaderElectionConfigBuilder> implements VisitableBuilder<LeaderElectionConfig,LeaderElectionConfigBuilder>{
  public LeaderElectionConfigBuilder() {
    this(false);
  }
  public LeaderElectionConfigBuilder(Boolean validationEnabled) {
    this.fluent = this; this.validationEnabled=validationEnabled;
  }
  public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,Boolean validationEnabled) {
    this.fluent = fluent; this.validationEnabled=validationEnabled;
  }
  public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,LeaderElectionConfig instance) {
    this(fluent, instance, false);
  }
  public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,LeaderElectionConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLock(instance.getLock());
      fluent.withLeaseDuration(instance.getLeaseDuration());
      fluent.withRenewDeadline(instance.getRenewDeadline());
      fluent.withRetryPeriod(instance.getRetryPeriod());
      fluent.withLeaderCallbacks(instance.getLeaderCallbacks());
      fluent.withReleaseOnCancel(instance.isReleaseOnCancel());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LeaderElectionConfigBuilder(LeaderElectionConfig instance) {
    this(instance,false);
  }
  public LeaderElectionConfigBuilder(LeaderElectionConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLock(instance.getLock());
      this.withLeaseDuration(instance.getLeaseDuration());
      this.withRenewDeadline(instance.getRenewDeadline());
      this.withRetryPeriod(instance.getRetryPeriod());
      this.withLeaderCallbacks(instance.getLeaderCallbacks());
      this.withReleaseOnCancel(instance.isReleaseOnCancel());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  LeaderElectionConfigFluent<?> fluent;
  Boolean validationEnabled;
  public LeaderElectionConfig build() {
    LeaderElectionConfig buildable = new LeaderElectionConfig(fluent.getLock(),fluent.getLeaseDuration(),fluent.getRenewDeadline(),fluent.getRetryPeriod(),fluent.getLeaderCallbacks(),fluent.isReleaseOnCancel(),fluent.getName());
    return buildable;
  }
  
}