/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.TestAsyncBody;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class StandardHttpClientTest {
    private TestStandardHttpClient client;

    StandardHttpClientTest() {
    }

    @BeforeEach
    void setup() {
        this.client = new TestStandardHttpClientFactory().newBuilder().build();
    }

    @Test
    void webSocketFutureCancel() {
        WebSocket ws = (WebSocket)Mockito.mock(WebSocket.class);
        CompletableFuture<WebSocketResponse> wsResponsefuture = new CompletableFuture<WebSocketResponse>();
        this.client.wsExpect(".*", wsResponsefuture);
        CompletableFuture future = this.client.newWebSocketBuilder().uri(URI.create("ws://localhost")).buildAsync(new WebSocket.Listener(){});
        future.cancel(true);
        wsResponsefuture.complete(new WebSocketResponse(new WebSocketUpgradeResponse(null, 101), ws));
        ((WebSocket)Mockito.verify((Object)ws)).sendClose(1000, null);
    }

    @Test
    void consumeBytesFutureCancel() {
        TestHttpResponse<Object> asyncResp = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class));
        CompletableFuture<HttpResponse<AsyncBody>> responseFuture = new CompletableFuture<HttpResponse<AsyncBody>>();
        this.client.expect("/path", responseFuture);
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost/path").build(), (value, asyncBody) -> {});
        consumeFuture.cancel(true);
        responseFuture.complete(asyncResp);
        ((AsyncBody)Mockito.verify((Object)asyncResp.body())).cancel();
    }

    @Test
    void sendAsyncFutureCancel() {
        TestHttpResponse<Object> asyncResp = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class));
        Mockito.when((Object)((AsyncBody)asyncResp.body()).done()).thenReturn(new CompletableFuture());
        CompletableFuture<HttpResponse<AsyncBody>> responseFuture = new CompletableFuture<HttpResponse<AsyncBody>>();
        this.client.expect("/path", responseFuture);
        CompletableFuture sendAsyncFuture = this.client.sendAsync(this.client.newHttpRequestBuilder().uri("http://localhost/path").build(), InputStream.class);
        sendAsyncFuture.cancel(true);
        responseFuture.complete(asyncResp);
        ((AsyncBody)Mockito.verify((Object)asyncResp.body())).cancel();
    }

    @Test
    void test10RetriesWithDefaultConfig() {
        IntStream.range(0, 11).forEach(i -> this.client.expect(".*", new IOException(i + " - Unreachable!")));
        CompletableFuture sendAsyncFuture = this.client.sendAsync(this.client.newHttpRequestBuilder().uri("http://localhost").build(), InputStream.class);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sendAsyncFuture.get(30L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(IOException.class)).hasMessage("10 - Unreachable!");
    }

    @Test
    void testHttpRetryWithMoreFailuresThanRetries() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(3)).withRequestRetryBackoffInterval(50)).build()).build();
        IntStream.range(0, 3).forEach(i -> this.client.expect(".*", new IOException("Unreachable!")));
        this.client.expect(".*", new TestHttpResponse().withCode(403));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        long start = System.currentTimeMillis();
        org.junit.jupiter.api.Assertions.assertEquals((int)403, (int)((HttpResponse)consumeFuture.get()).code());
        long stop = System.currentTimeMillis();
        org.junit.jupiter.api.Assertions.assertTrue((stop - start >= 350L ? 1 : 0) != 0);
        Assertions.assertThat(this.client.getRecordedConsumeBytesDirects()).hasSize(4);
    }

    @Test
    void testHttpRetryWithLessFailuresThanRetries() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(3)).withRequestRetryBackoffInterval(50)).build()).build();
        TestHttpResponse<TestAsyncBody> error = new TestHttpResponse().withCode(500).withBody(new TestAsyncBody());
        IntStream.range(0, 3).forEach(i -> this.client.expect(".*", (HttpResponse<AsyncBody>)error));
        this.client.expect(".*", new TestHttpResponse().withCode(200));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)((HttpResponse)consumeFuture.get(2L, TimeUnit.MINUTES)).code());
        Assertions.assertThat(this.client.getRecordedConsumeBytesDirects()).hasSize(4);
    }

    @Test
    void testWebSocketWithLessFailuresThanRetries() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(3)).withRequestRetryBackoffInterval(50)).build()).build();
        WebSocketResponse error = new WebSocketResponse(new WebSocketUpgradeResponse(null, 500), (Throwable)new IOException());
        IntStream.range(0, 2).forEach(i -> this.client.wsExpect(".*", error));
        this.client.wsExpect(".*", new WebSocketResponse(new WebSocketUpgradeResponse(null), (WebSocket)Mockito.mock(WebSocket.class)));
        CompletableFuture future = this.client.newWebSocketBuilder().uri(URI.create("ws://localhost")).buildAsync(new WebSocket.Listener(){});
        future.get(2L, TimeUnit.MINUTES);
        Assertions.assertThat(this.client.getRecordedBuildWebSocketDirects()).hasSize(3);
    }

    @Test
    void testClosePreviousBeforeRetry() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(1)).withRequestRetryBackoffInterval(50)).build()).build();
        TestHttpResponse<Object> error = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class)).withCode(503);
        this.client.expect(".*", error);
        this.client.expect(".*", new TestHttpResponse().withCode(200));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        ((AsyncBody)Mockito.verify((Object)error.body())).cancel();
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)((HttpResponse)consumeFuture.get(2L, TimeUnit.MINUTES)).code());
        Assertions.assertThat(this.client.getRecordedConsumeBytesDirects()).hasSize(2);
    }

    @Test
    void testRequestTimeout() {
        this.client.expect(".*", new CompletableFuture<HttpResponse<AsyncBody>>());
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").timeout(1L, TimeUnit.MILLISECONDS).build(), (value, asyncBody) -> {});
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(consumeFuture::isDone);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(consumeFuture::get).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(TimeoutException.class);
    }

    @Test
    void testMultiValueHeader() {
        TestHttpResponse response = new TestHttpResponse(Collections.singletonMap("header", Arrays.asList("a", "b")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a,b", (Object)response.header("header"));
    }

    @Test
    void retryAfterWithNoHeaderDefaultsToZero() {
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)StandardHttpClient.retryAfterMillis(new TestHttpResponse()));
    }

    @ParameterizedTest(name="{index}: retryAfter={0} has a retry interval between {1} and {2} milliseconds")
    @MethodSource(value={"testRetryAfterParsingData"})
    void testRetryAfterParsing(List<String> retryAfter, int lowerBound, int upperBound) {
        Assertions.assertThat((long)StandardHttpClient.retryAfterMillis(new TestHttpResponse(Collections.singletonMap("Retry-After", retryAfter)))).isGreaterThanOrEqualTo((long)lowerBound).isLessThanOrEqualTo((long)upperBound);
    }

    public static Stream<Arguments> testRetryAfterParsingData() {
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.emptyList(), 0, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList("2"), 2000, 2000}), Arguments.of((Object[])new Object[]{Collections.singletonList("invalid"), 0, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList(ZonedDateTime.now().plusSeconds(10L).format(DateTimeFormatter.RFC_1123_DATE_TIME)), 1001, 10000}));
    }
}

